#include <stdio.h>
#include <math.h>

enum eckig { ja, nein };

class Form          // Basisklasse 
{                   
                    // In der Basisklasse werden alle gemeinsamen Variablen
  protected:          
    eckig m_hat_ecken;
    float m_umfang;
    float m_flaeche;
 
  public:                   // sowie auch alle gemeinsamen Methoden deklariert
    float leseUmfang() { return m_umfang; }
    float leseFlaeche() { return m_flaeche; }

    Form(eckig hat_ecken);
};

Form::Form(eckig ecken) {   // im Konstruktor werden gem. Variablen initialisiert
    m_hat_ecken = ecken;
    m_umfang = 0;
    m_flaeche = 0;
};

class Kreis : public Form { // Hier wird eine von Form abgeleitete Klasse Kreis deklariert
    
  protected:                // Zugriffschutz protected bedeutet, dass abgeleitete 
                            // Klassen ebenfalls zugreifen können.
    float m_radius;
    
  public:                   
    float leseUmfang();
    float leseFlaeche();
    
    Kreis(float radius);    // Neuer Konstruktor erfordert nur den radius 
};


class Rechteck : public Form { 
    
    //Rechteck benötigt neue Membervariablen
  protected:     
    float seite_a;
    float seite_b;
    
  public:                   
    float leseUmfang();
    float leseFlaeche();
    
    Rechteck(float a, float b);    
};

Rechteck::Rechteck(float a, float b) : Form(ja) {
    seite_a = a;
    seite_b = b;
    
    //Umfang und Flaeche werden mit dem Protected Variablen
    //der Unterklasse Rechteck ausgerechnet
    m_umfang = (2*a) + (2*b);
    m_flaeche = a*b;
};


Kreis::Kreis(float radius) : Form(nein) {
    // Im Konstruktor werden gleich die Membervariablen initialisiert
    
    // Über den radius werden Umfang und Fläche berechnet. 
    m_umfang = 2 * radius * M_PI;  // Die Konstante M_PI ist in math.h definiert
    m_flaeche = radius * radius * M_PI;
};

float Kreis::leseUmfang() {
                                // hier ist keine Änderung der Funktion nötig,
                                // daher wird die Funktion der Basisklasse aufger.
    return m_umfang; 
}

float Kreis::leseFlaeche(){
    return m_flaeche;
}


float Rechteck::leseUmfang(){  
    return m_umfang;
}
float Rechteck::leseFlaeche(){
    return m_flaeche;
}



int main()
{
    printf("Wir arbeiten nun mit abgeleiteten Klassen!\n");
    printf("Nun wird ein Objekt kr der Klasse Kreis erzeugt!\n");
    Kreis kr(1.0);
    Rechteck re(2.0, 3.0);
    
    float um = kr.leseUmfang();
    
    float umf = re.leseUmfang();
    
    
    float fl = re.leseFlaeche();
    
    printf("Der Umfang des Kreis beträgt: %f\n", um);
    printf("Der Umfang des Rechtecks beträgt: %f\n", umf);
    printf("Die Flaeche des Rechtecks beträgt: %f\n", fl);
    return 0;
}
