#include <stdio.h>
#include <math.h>
#include <iostream>

namespace SECHS_ABELI {                         //Festlegung des Namespaces
    
    enum angular { yes, no };                   
    
    class Shape {                               //Basisklasse wäre eventuell Kanidat für abstrakte Klasse
                   
    protected:                  //Gemeinsame Variablen für Subklassen
        angular m_gotCorners;
        float m_scope;
        float m_surface;
                                //Allgemeine Methoden für alle Arten von Formen Berechnende, Speichernde und Default setzer
    private:    
        inline void angularSet( angular gotCorners) { m_gotCorners = gotCorners; }
        inline void scopeSetDefault() { m_scope = 0; }              //SetDefault Methoden um spätere Rechenfehler auszuschließen
        inline void surfaceSetDefault() { m_surface = 0; }
                                //Allgmeine Methoden zum auslesen der Gemeinsamen Variablen
    public:
        inline const char* getAngular() { return ((m_gotCorners==1) ? "Nein":"Ja"); } //Gibt ein Format zurück welches von cout ausgegeben werden kann
        inline float getScope() { return m_scope; }
        inline float getSurface() { return m_surface; }

        Shape(angular gotCorners); 
    };

    Shape::Shape(angular gotCorners) {      //Im Konstruktor werden die allg. Variablen gesetzt bzw. auf Default (=0) gesetzt
    
        angularSet(gotCorners);
        scopeSetDefault();
        surfaceSetDefault();
    };

    class Circle : public Shape {       // Hier wird eine von der Basisklasse Shape abgeleitete Klasse Circle deklariert
    
    protected:                
        float m_radius;     //Kreisklasse benötigt nur Radius als neue Variable welche auch von möglichen Subklassen verwendet werden kann

    private:
        inline void calcScope( float radius ) { m_scope = (radius+radius)*M_PI; }           //Kreisspezifische Umfangsberechnung, deswegen privat
        inline void calcSurface( float radius ) { m_surface = radius*radius*M_PI; }         //Kreisspezifische Flächenberechnung, selbes wie Umfang
    
    public:
        inline void setRadius(float radius) { calcScope(radius); calcSurface(radius); m_radius=radius; }    //Externer Schreibzugriff auf Klasse um Radius zu setzen
                                                                                                            //incl. der neuberechnungen von A und U
        inline float getRadius() { return m_radius; }                                                       //Externe Leseabfrage von Radius
    
        Circle(float radius);
    };

    Circle::Circle(float radius) : Shape(no) { //Konstruktor der Klasse Circle
        setRadius(radius); 
    };

    class Rectangle : public Shape {        //Hier wird eine von der Basisklasse Shape abgeleitete Klasse Rectangle deklariert
    
    protected:              //Variablen und Methoden zur berechnung welche für Rechtecke (aber auch Quadrate) verwendet werden
        float m_length;
        float m_width;
      
        inline void calcScope( float length, float width ) { m_scope = (2*length)+(2*width); }
        inline void calcSurface( float length, float width ) { m_surface = length*width; }
        inline void defaultSetWL() { m_length=0; m_width=0;}        //defaultsetzen von neuen Variablen für Subklassen um Berechnungsfehler auszuschließen
      
    public:
        void setWidth( float width);                //Externer Schreibzugriff für die Breite
        void setLength( float length);              //Externer Schreibzugriff für die Länge
      
        inline float getWidth() { return m_width; }     //Externer Lesezugriff für Breite
        inline float getLength() { return m_length; }   //Externer Lesezugriff für die Länge (public das auch Subklasse Square zugreiffen kann)
      
        Rectangle(float length, float width);
    };

    Rectangle::Rectangle(float length, float width) : Shape(yes) {  //Konstruktoraufruf der Variablen setzt und berechnet
        
        defaultSetWL();
        setLength(length);
        setWidth(width);
    };

    void Rectangle::setWidth( float width ) {   // Methode für verändernten Schreibzugriff (Breite) und aktualisierung der Objektdaten
        
        calcScope( m_length, width);
        calcSurface( m_length, width);
        m_width=width;
    }

    void Rectangle::setLength( float length ) { // Methode für verändernten Schreibzugriff (Länge) und aktualisierung der Objektdaten
        calcScope( length, m_width);
        calcSurface( length, m_width);
        m_length=length;
    }

    class Square : public Rectangle {           //Hier wird eine von der Basisklasse Shape abgeleitete Klasse Rectangle weiter zur Klasse Square abgeleitet
    
        public:                                 //Besitzt keine spezifischeren Daten wie Rectangle deswegen nur Schreibzugriff möglich welcher Werte in übergeordneten
        void setSide( float side);              //Klasse Rectangle setzt
    
        Square(float side);
    };

    Square::Square(float side) : Rectangle(side, side) {    //Leerer Konstruktor für Square Welcher nur die Werte der übergeordneten Klasse setzen soll
        
    }

    void Square::setSide(float side) {      //Methode für den Externen Zugriff auf Seitenlänge von dem Square
        
        setLength(side);
        setWidth(side);
    }

}

using namespace std;                //Aufruf der benötigten Namespaces
using namespace SECHS_ABELI;        

int main()
{
    cout<<"Wir arbeiten nun mit abgeleiteten Klassen!"<<endl<<endl;             //Hauptprogramm Demo für gegebene Funktion
    
    cout<<"Nun wird ein Objekt kr der Klasse Circle erzeugt!"<<endl;
    Circle ci(3.0f);
    cout<<"Der Kreis hat Ecken: "<<ci.getAngular()<<endl<<
          "Der Radius des Kreises beträgt: "<<ci.getRadius()<<endl<<
          "Der Umfang des Kreis beträgt: "<<ci.getScope()<<endl<<
          "Der Fläche des Kreises beträgt: "<<ci.getSurface()<<endl<<
          "========================================"<<endl;
    
    cout<<"Nun wird ein Objekt re der Klasse Rectangle erzeugt!"<<endl;
    Rectangle re(3.0f, 4.0f);
    cout<<"Das Rechteck hat Ecken: "<<re.getAngular()<<endl<<
          "Der Länge des Rechtecks beträgt: "<<re.getWidth()<<endl<<
          "Die Breite des Rechtecks beträgt: "<<re.getLength()<<endl<<
          "Der Umfang des Rechtecks beträgt: "<<re.getScope()<<endl<<
          "Der Fläche des Rechtecks beträgt: "<<re.getSurface()<<endl<<
          "========================================"<<endl;
          
    cout<<"Nun wird ein Objekt sq der Klasse Square erzeugt!"<<endl;
    Square sq(5.0f);
    cout<<"Das Quadrat hat Ecken: "<<sq.getAngular()<<endl<<
          "Der Länge des Quadrates beträgt: "<<sq.getWidth()<<endl<<
          "Die Breite des Quadrates beträgt: "<<sq.getLength()<<endl<<
          "Der Umfang des Quadrates beträgt: "<<sq.getScope()<<endl<<
          "Der Fläche des Quadrates beträgt: "<<sq.getSurface()<<endl<<
          "========================================"<<endl;
    return 0;
}

/* Lauffähigkeit auf OnlineGDB Compiler getestet*/