/******************************************************************************

C++ Kurs BULME 19/20 SM
Datei 04

- Vererbung einer Basisklasse an abgeleitete Klassen

Eine Klasse kann als die Basis für die Entwicklung einer neuen Klasse verwendet 
werden, ohne dass ihr Code geändert werden muss. Dazu wird die neue Klasse 
definiert, indem angegeben wird, dass sie eine abgeleitete Klasse der 
Basisklasse ist. 

Während es in der letzten Lektion um den Aspekt der Kapselung gegangen ist,
geht es hier um den Aspekt der Vererbung. 


/* Ihre Aufgaben!
   1. Ergänzen Sie die Klasse Kreis um die Methode float berechneFlaeche();
   
   2. Leiten Sie von der Basisklasse Form die Klasse Rechteck ab
      Überlegen Sie sich welche Parameter der Konstruktur für die Klasse
      Rechteck benötigt. Implementieren sie neben dem Konstruktor auch alle 
      Methoden der Basisklasse, sodass korrekte Werte berechnet werden.
      
   3. Optional: Leiten Sie von der Klasse Rechteck die Klasse Quadrat ab.
      Implementieren Sie Konstruktor und alle Methoden in der Form, dass 
      die Implementierungen der Klasse Rechteck genutzt werden.



form, rechteck, quadrat (subklasse von rechteck)
*/
/*******************************************************************************/
#include <stdio.h>
#include <math.h>

enum eckig { ja, nein };

class Form          // Basisklasse 
{                   
                    // In der Basisklasse werden alle gemeinsamen Variablen
  protected:          
    eckig m_hat_ecken;
    float m_umfang;
    float m_flaeche;
  
  public:                   // sowie auch alle gemeinsamen Methoden deklariert
    float leseUmfang() { return m_umfang; };
    float leseFlaeche() { return m_flaeche; };

    Form(eckig hat_ecken); //konstruktor
};

Form::Form(eckig ecken) {   // im Konstruktor werden gem. Variablen initialisiert
    m_hat_ecken = ecken;
    m_umfang = 0;
    m_flaeche = 0;
};


//Kreis
class Kreis : public Form { // Hier wird eine von Form abgeleitete Klasse Kreis deklariert
    
  protected:                // Zugriffschutz protected bedeutet, dass abgeleitete 
    float m_radius;           // Klassen ebenfalls zugreifen können.

  public:                   
    Kreis(float radius);    // Neuer Konstruktor erfordert nur den radius 
};

Kreis::Kreis(float radius) : Form(nein) {
    // Im Konstruktor werden gleich die Membervariablen initialisiert
    
    // Über den radius werden Umfang und Fläche berechnet. 
    m_umfang = 2 * radius * M_PI;  // Die Konstante M_PI ist in math.h definiert
    m_flaeche = radius * radius * M_PI;
};



/*
 2. Leiten Sie von der Basisklasse Form die Klasse Rechteck ab
      Überlegen Sie sich welche Parameter der Konstruktur für die Klasse
      Rechteck benötigt. Implementieren sie neben dem Konstruktor auch alle 
      Methoden der Basisklasse, sodass korrekte Werte berechnet werden.
*/


//Rechteck
class Rechteck : public Form {
    
    protected:
    float m_length;
    float m_width;
    
    public:
    Rechteck(float length,float width);
    float getm_length();
    float getm_width();
};

Rechteck::Rechteck(float length,float width) : Form(ja) {
    m_length=length;
    m_width=width;
    m_umfang = 2*length+2*width;
    m_flaeche = length * width;
};

float Rechteck::getm_length()
{
    return m_length;
}

float Rechteck::getm_width()
{
    return m_width;
}



/*
   3. Optional: Leiten Sie von der Klasse Rechteck die Klasse Quadrat ab.
      Implementieren Sie Konstruktor und alle Methoden in der Form, dass 
      die Implementierungen der Klasse Rechteck genutzt werden.
*/

//quadrat

class Quadrat : public Rechteck{
public:
    Quadrat(float length);    
};

Quadrat::Quadrat(float length) : Rechteck(length,length) { //'width’ not declared 
    //m_umfang=4*length;
    //m_flaeche=length*length;
}






int main()
{
    printf("Wir arbeiten nun mit abgeleiteten Klassen!\n");
    printf("Nun wird ein Objekt kr der Klasse Kreis erzeugt!\n");
    Kreis kr(1.0);
    float um = kr.leseUmfang();
    printf("\nDer Umfang des Kreis beträgt: %0.4f\n", um);
    float fl=kr.leseFlaeche();
    printf("Die Flaeche des Kreis beträgt: %0.4f\n", fl);
    
    
    Rechteck re(1.0,2.0);
    printf("\nDie Rechteck-Länge: %0.2f\n", re.getm_length());
    printf("Die Rechteck-Breite: %0.2f\n", re.getm_width());
    printf("Der Umfang des Rechtecks beträgt: %0.4f\n", re.leseUmfang());
    printf("Die Flaeche des Rechtecks beträgt: %0.4f\n", re.leseFlaeche());
    
    Quadrat qu(2.5);
    printf("\nDie Quadrat-Länge: %0.2f\n", qu.getm_length());
    printf("Der Umfang des Quadrats beträgt: %0.4f\n", qu.leseUmfang());
    printf("Die Flaeche des Quadrats beträgt: %0.4f\n", qu.leseFlaeche());
    
    
    return 0;
}

/*
  Weiterführende Links:
  https://os.mbed.com/users/fpucher/code/HIM0Board/wiki/Vererbung-in-C++
  https://de.wikibooks.org/wiki/C%2B%2B-Programmierung:_Vererbung
*/


