/******************************************************************************

Aufgabe 02 - Vererbungen
basierend auf Datei 04

*******************************************************************************

Ihre Aufgaben!
   1. Ergänzen Sie die Klasse Kreis um die Methode float leseFlaeche();
   
   2. Leiten Sie von der Basisklasse Form die Klasse Rechteck ab
      Überlegen Sie sich welche Parameter der Konstruktur für die Klasse
      Rechteck benötigt. Implementieren sie neben dem Konstruktor auch alle 
      Methoden der Basisklasse, sodass korrekte Werte berechnet werden.
      
   3. Optional: Leiten Sie von der Klasse Rechteck die Klasse Quadrat ab.
      Implementieren Sie Konstruktor und alle Methoden in der Form, dass 
      die Implementierungen der Klasse Rechteck genutzt werden.
      Quadrat soll eine Subklasse von Rechteck sein.
      
      Format der Dateinamen: <Nachname>_<Übungsnummer>_<Titel>
      Bsp: Brunnhofer_2_Vererbung
      
      Hinweis: Der Quellcode der Programme sollte auch kommentiert werden!
      
      
      
    Weiterführende Links:
    https://os.mbed.com/users/fpucher/code/HIM0Board/wiki/Vererbung-in-C++
    https://de.wikibooks.org/wiki/C%2B%2B-Programmierung:_Vererbung

*******************************************************************************/

#include <stdio.h>
#include <math.h>

enum eckig { ja, nein };

class Form                                  // Basisklasse 
{                   
                                            // In der Basisklasse werden alle gemeinsamen Variablen
  protected:          
    eckig m_hat_ecken;
    float m_umfang;
    float m_flaeche;
 
  public:                                   // sowie auch alle gemeinsamen Methoden deklariert
    float leseUmfang() {return m_umfang; }
    float leseFlaeche() {return m_flaeche; }

    Form(eckig hat_ecken);
};

Form::Form(eckig ecken)                     // im Konstruktor werden gem. Variablen initialisiert
{       
    m_hat_ecken = ecken;
    m_umfang = 0;
    m_flaeche = 0;
};

class Kreis : public Form                   // Hier wird eine von Form abgeleitete Klasse Kreis deklariert
{ 
    
  protected:                                // Zugriffschutz protected bedeutet, dass abgeleitete 
                                            // Klassen ebenfalls zugreifen können.
    float m_radius;
    
  public:           
/******************************************************************************
    1. Ergänzen Sie die Klasse Kreis um die Methode float leseFlaeche();
*******************************************************************************/  
    float leseFlaeche() { return m_flaeche; }
/******************************************************************************/  
    float leseUmfang() { return m_umfang; }
    Kreis(float radius);                        // Neuer Konstruktor erfordert nur den radius 
};

Kreis::Kreis(float radius) : Form(nein)         // Im Konstruktor werden gleich die Membervariablen initialisiert
{
                                                // Über den radius werden Umfang und Fläche berechnet. 
    m_umfang = 2 * radius * M_PI;               // Die Konstante M_PI ist in math.h definiert
    m_flaeche = radius * radius * M_PI;
};

/******************************************************************************
    2. Leiten Sie von der Basisklasse Form die Klasse Rechteck ab
      Überlegen Sie sich welche Parameter der Konstruktur für die Klasse
      Rechteck benötigt. Implementieren sie neben dem Konstruktor auch alle 
      Methoden der Basisklasse, sodass korrekte Werte berechnet werden.
*******************************************************************************/  
class Rechteck : public Form                    // Erstellen der von Form abgeleitete Klasse Rechteck
{
    protected:
     float m_laenge; 
     float m_breite; 
 
   public:    
     float leseUmfang() { return m_umfang; } 
     float leseFlaeche() { return m_flaeche; }
    
    Rechteck(float m_laenge);                   // Deklaration des Konstruktors
    Rechteck(float m_laenge, float m_breite);
};


Rechteck::Rechteck(float m_laenge) : Form(ja){}; // Definition des Konstruktors, :: gibt die Klassenzugehörigkeit an
Rechteck::Rechteck(float m_laenge, float m_breite) : Form(ja)
{
   m_umfang = 2*m_laenge + 2*m_breite;          // über die Seitenmaße m_laenge und m_breite werden Umfang und Fläche berechnet
   m_flaeche = m_laenge * m_breite; 
};
/******************************************************************************/ 

/******************************************************************************
    3. Optional: Leiten Sie von der Klasse Rechteck die Klasse Quadrat ab.
      Implementieren Sie Konstruktor und alle Methoden in der Form, dass 
      die Implementierungen der Klasse Rechteck genutzt werden.
      Quadrat soll eine Subklasse von Rechteck sein.
*******************************************************************************/  
class Quadrat : public Rechteck                 // Erstellen der von Rechteck abgeleitete Klasse Quadrat
{
   public:    
    float leseUmfang() { return m_umfang; } 
    float leseFlaeche() { return m_flaeche; }
    
    Quadrat(float m_laenge);                    // Deklaration des Konstruktors
};
 
Quadrat::Quadrat(float m_laenge) : Rechteck (m_laenge)   // Definition des Konstruktors
{
    m_umfang = 4*m_laenge;                      // über die Seitenlänge m_laenge werden Umfang und Fläche berechnet
    m_flaeche = m_laenge*m_laenge;
};
/******************************************************************************/ 

int main()
{
    
    
    
    Kreis kreis1(1.0);                          //Aufruf der Methoden und Übergabe der Parameter
    printf("Kreis:\n");
    printf("Umfang: %f m.\n", kreis1.leseUmfang());
    printf("Fläche: %f m².\n\n", kreis1.leseFlaeche());
    
    Rechteck reckteck1(3.0,2.0);
    printf("Quadrat:\n");
    printf("Umfang: %f m.\n", reckteck1.leseUmfang());
    printf("Fläche: %f m².\n\n", reckteck1.leseFlaeche());
   
    Quadrat quadrat1(5.0);
    printf("Quadrat:\n");
    printf("Umfang: %f m.\n", quadrat1.leseUmfang());
    printf("Fläche: %f m².\n\n", quadrat1.leseFlaeche());
    return 0;
}



