#include "mbed.h"
#include "WiflyInterface.h"
//#include "stdio.h"

// ATTENTION IL FAUT PEUT ETRE REMPLACER LES $0a$0d par \r\n

const char GPOn1[]="GET /bacpac/PW?t=goprohero&p=%01 HTTP/1.0\n\r\n\r";
const char GPOn2[]="GET /bacpac/PW?t=goprohero&p=%01 HTTP/1.0$0a$0d$0a$0d";
const char GPOff1[]="GET /bacpac/PW?t=goprohero&p=%00 HTTP/1.0\n\r\n\r";
const char GPOff2[]="GET /bacpac/PW?t=goprohero&p=%00 HTTP/1.0$0a$0d$0a$0d";
const char GPStartCapt[]="GET /bacpac/SH?t=goprohero&p=%01 HTTP/1.0$0a$0d$0a$0d";
const char GPStopCapt[]="GET /bacpac/SH?t=goprohero&p=%00 HTTP/1.0$0a$0d$0a$0d";
const char GPCamera[]="GET /camera/CM?t=goprohero&p=%00 HTTP/1.0$0a$0d$0a$0d";
const char GPPhoto[]="GET /camera/CM?t=goprohero&p=%01 HTTP/1.0$0a$0d$0a$0d";

#define brTX PA_9  // TX STM32
#define brRX PA_10  // RX STM32
#define brRESET PA_8  // RESET WiFly
#define brTCP PB_10     // SENS7 Wifly

unsigned int modeOnOff1=0;
unsigned int modeOnOff2=0;
unsigned int modeSt=0;
unsigned int modeMode=0;


Serial pc(USBTX, USBRX);
WiflyInterface wifly(brTX, brRX, brRESET, brTCP, "GOPRO-BP-D896855897e8", "goprohero", WPA);

/* wifly object where:
*     - "goprokekechose" is the ssid of the network
*     - "goprohero" is the password
*     - WPA is the security
*/

void menu(void)
{
    pc.printf("--------------------\n\r");
    pc.printf(" ON - OFF va : a \n\r");    
    pc.printf(" ON - OFF vb : b \n\r");    
    pc.printf(" PHOTO :       s \n\r");    
    pc.printf(" MODE :        v \n\r");    
    pc.printf(" DECONNEXION : d \n\r");  
    pc.printf("--------------------\n\r");  
}

int main()
{
    char c;
    pc.printf("Connexion au module WiFly\r\n");
    int s=wifly.init(); // use DHCP
    if( s != NULL )    {
        pc.printf( "Erreur d'initialisation!\n" );        
        exit( 0 );  // Ou va t on ? Que fait on ?
    }   
    while (!wifly.connect()); // join the network
    
    pc.printf("IP Address is %s\n\r", wifly.getIPAddress());
    wifly.sendCommand("set ip host 10.5.5.9\r", "AOK");
    wifly.sendCommand("set ip remote 80\r", "AOK");
    wifly.sendCommand("set comm idle 5\r", "AOK");
    wifly.sendCommand("set comm remote 0\r", "AOK");
    wifly.sendCommand("set uart mode 2\r", "AOK");
    wifly.exit();        
    menu();
    while(1) {
          if (pc.readable()) {
            c=pc.getc();
            switch(c)  {
                case 'a' : 
                if (modeOnOff1) wifly.send(GPOff1,sizeof(GPOff1));
                else wifly.send(GPOn1,sizeof(GPOn1));
                modeOnOff1=!modeOnOff1;
                pc.printf("modeOnOff1: %d\n\r",modeOnOff1);
                break;
                
                case 'b' : 
                if (modeOnOff2) wifly.send(GPOff2,sizeof(GPOff2));
                else wifly.send(GPOn2,sizeof(GPOn2));
                modeOnOff2=!modeOnOff2;
                pc.printf("modeOnOff2: %d\n\r",modeOnOff2);
                break;
    
                case 's':
                    if (modeSt) wifly.send(GPStartCapt,sizeof(GPStartCapt));
                    else wifly.send(GPStopCapt,sizeof(GPStopCapt));
                    modeSt=!modeSt;
                    pc.printf("modeSt: %d\n\r",modeSt);
                    break;
    
                case 'm':
                    if (modeMode) wifly.send(GPCamera,sizeof(GPCamera));
                    else wifly.send(GPPhoto,sizeof(GPPhoto));
                    modeMode=!modeMode;
                    pc.printf("modeMode: %d\n\r",modeMode);
                    break;
                    
                case 'd':
                    wifly.disconnect();
                    break;
            }
            menu();
        }
    }



}