/* WiFi Example
 * Copyright (c) 2016 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
 
/* adaptation pour demo commande camera GOPRO
 * C.Dupaty 04-2018   
 */

#include "mbed.h"
#include "TCPSocket.h"

#define WIFI_ESP8266    1
#define WIFI_IDW0XX1    2

#if TARGET_UBLOX_EVK_ODIN_W2
#include "OdinWiFiInterface.h"
OdinWiFiInterface wifi;

#elif TARGET_REALTEK_RTL8195AM
#include "RTWInterface.h"
RTWInterface wifi;

#else // External WiFi modules

#if MBED_CONF_APP_WIFI_SHIELD == WIFI_ESP8266
#include "ESP8266Interface.h"
ESP8266Interface wifi(MBED_CONF_APP_WIFI_TX, MBED_CONF_APP_WIFI_RX);
#elif MBED_CONF_APP_WIFI_SHIELD == WIFI_IDW0XX1
#include "SpwfSAInterface.h"
SpwfSAInterface wifi(MBED_CONF_APP_WIFI_TX, MBED_CONF_APP_WIFI_RX);
#endif // MBED_CONF_APP_WIFI_SHIELD == WIFI_IDW0XX1

#endif

Serial pc(USBTX,USBRX);

char photo[]="GET /bacpac/SH?t=goprofourcade&p=%01 HTTP/1.0\r\n\r\n"; // requete de prise de vue


const char *sec2str(nsapi_security_t sec)
{
    switch (sec) {
        case NSAPI_SECURITY_NONE:
            return "None";
        case NSAPI_SECURITY_WEP:
            return "WEP";
        case NSAPI_SECURITY_WPA:
            return "WPA";
        case NSAPI_SECURITY_WPA2:
            return "WPA2";
        case NSAPI_SECURITY_WPA_WPA2:
            return "WPA/WPA2";
        case NSAPI_SECURITY_UNKNOWN:
        default:
            return "Unknown";
    }
}

int scan_demo(WiFiInterface *wifi)
{
    WiFiAccessPoint *ap;

    pc.printf("Scan:\n");

    int count = wifi->scan(NULL,0);

    /* Limit number of network arbitrary to 15 */
    count = count < 15 ? count : 15;

    ap = new WiFiAccessPoint[count];
    count = wifi->scan(ap, count);
    for (int i = 0; i < count; i++)
    {
        pc.printf("Network: %s secured: %s BSSID: %hhX:%hhX:%hhX:%hhx:%hhx:%hhx RSSI: %hhd Ch: %hhd\n", ap[i].get_ssid(),
               sec2str(ap[i].get_security()), ap[i].get_bssid()[0], ap[i].get_bssid()[1], ap[i].get_bssid()[2],
               ap[i].get_bssid()[3], ap[i].get_bssid()[4], ap[i].get_bssid()[5], ap[i].get_rssi(), ap[i].get_channel());
    }
    pc.printf("%d networks available.\n", count);

    delete[] ap;
    return count;
}

void envoie_commande(NetworkInterface *net, char *sbuffer)
{
    pc.printf("\x1B[33m");  //texte jaune
    TCPSocket socket;
    nsapi_error_t response;

    pc.printf("Sending HTTP request to gopro...\n");

    // Open a socket on the network interface, and create a TCP connection to www.arm.com
    socket.open(net);
    response = socket.connect("10.5.5.9", 80);
    if(0 != response) {
        pc.printf("Error connecting: %d\n", response);
        socket.close();
        pc.printf("\x1B[37m");  //texte blanc
        return;
    }
    else pc.printf("Connexion etablie\r\n");

    // Send a simple http request
    //  char sbuffer[] = "GET /bacpac/SH?t=goprofourcade&p=%01 HTTP/1.0\r\n\r\n";
   // char sbuffer[] = "GET / HTTP/1.1\r\nhost: 10.5.5.9\r\n\r\n";
    nsapi_size_t size = strlen(sbuffer);
    response = 0;
    while(size)
    {
        response = socket.send(sbuffer+response, size);
        if (response < 0) {
            pc.printf("Error sending data: %d\n", response);
            socket.close();
            pc.printf("\x1B[37m");  //texte blanc
            return;
        } else {
            size -= response;
            // Check if entire message was sent or not
            pc.printf("sent %d [%.*s]\n", response, strstr(sbuffer, "\r\n")-sbuffer, sbuffer);
        }
    }

    // Recieve a simple http response and print out the response line
    char rbuffer[64];
    response = socket.recv(rbuffer, sizeof rbuffer);
    if (response < 0) {
        pc.printf("Error receiving data: %d\n", response);
    } else {
        pc.printf("recv %d [%.*s]\n", response, strstr(rbuffer, "\r\n")-rbuffer, rbuffer);
        pc.printf("%s\r\n",rbuffer);
    }

    // Close the socket to return its memory and bring down the network interface
    socket.close();
    pc.printf("\x1B[37m");  //texte blanc
}

int main()
{
 //   int count = 0;
    pc.printf("\x1B[2J");  //efface ecran
    pc.printf("\x1B[0;0H");   // curseur en 0,0
    pc.printf("\x1B[37m");  //texte blanc
    pc.printf("-----------------------------------------------------------\r\n");
    pc.printf("Exemple de controle de camera GOPRO par WIFI\r\n");
    pc.printf("La camera GOPRO doit etre en marche, WIFI actif, mode photo\r\n");
    pc.printf("-----------------------------------------------------------\r\n");
/*  // Exploration 
    count = scan_demo(&wifi);
    if (count == 0) {
        pc.printf("No WIFI APNs found - can't continue further.\n");
        return -1;
    }
*/
    pc.printf("\nTentative de connection sur la borne WIFI %s...\n", MBED_CONF_APP_WIFI_SSID);
    int ret = wifi.connect(MBED_CONF_APP_WIFI_SSID, MBED_CONF_APP_WIFI_PASSWORD, NSAPI_SECURITY_WPA_WPA2);
    if (ret != 0) {
        pc.printf("\nConnection error\n");
        return -1;
    }

    pc.printf("Connexion reussie\n\n");
    pc.printf("MAC: %s\n", wifi.get_mac_address());
    pc.printf("IP: %s\n", wifi.get_ip_address());
    pc.printf("Netmask: %s\n", wifi.get_netmask());
    pc.printf("Gateway: %s\n", wifi.get_gateway());
    pc.printf("RSSI: %d\n\n", wifi.get_rssi());

    char * commande = photo;  // un exemple pour prendre une photo
                              // la camera doit activee être en mode photo
    char c='a';
    while(c!='q')
    {
        while(pc.readable())c=pc.getc();
        pc.printf("\r\nTaper q pour quitter\n\r");
        pc.printf("ou n'importe quelle touche pour prendre une photo \n\r");
        while(!pc.readable());
        envoie_commande(&wifi,commande);
    }
    wifi.disconnect();
   
    pc.printf("Wifi deconnecte - fin du programme\n\r");
    while(1);
}
