
#include "mbed.h"
#include "Serial.h"
#include "MPU9250.h"

//Serial pc(USBTX,USBRX);
Serial pc(p19,p20);
MPU9250 mpu9250;
uint8_t whoAmI = 0;

int main() {

		whoAmI = mpu9250.readByte(MPU9250_ADDRESS, WHO_AM_I_MPU9250);
		pc.printf("\r\WHO_AM_I_MPU9250 = %x \r\n",whoAmI);
	
		mpu9250.resetMPU9250(); // Reset registers to default in preparation for device calibration
 
		mpu9250.MPU9250SelfTest(SelfTest); // Start by performing self test and reporting values
		pc.printf("x-axis self test: acceleration trim within: %f pct of factory value\n\r", SelfTest[0]);  
		pc.printf("y-axis self test: acceleration trim within: %f pct of factory value\n\r", SelfTest[1]);  
		pc.printf("z-axis self test: acceleration trim within: %f pct of factory value\n\r", SelfTest[2]);  
		pc.printf("x-axis self test: gyration trim within: %f pct of factory value\n\r", SelfTest[3]);  
		pc.printf("y-axis self test: gyration trim within: %f pct of factory value\n\r", SelfTest[4]);  
		pc.printf("z-axis self test: gyration trim within: %f pct of factory value\n\r", SelfTest[5]);  
 
		mpu9250.getAres(); // Get accelerometer sensitivity
		mpu9250.getGres(); // Get gyro sensitivity
		mpu9250.getMres(); // Get magnetometer sensitivity
		pc.printf("Accelerometer sensitivity is %f LSB/g \n\r", 1.0f/aRes);
		pc.printf("Gyroscope sensitivity is %f LSB/deg/s \n\r", 1.0f/gRes);
		pc.printf("Magnetometer sensitivity is %f LSB/G \n\r", 1.0f/mRes);	

    while (true) {
		int16_t accData[3];
		int16_t gyroData[3];
		int16_t magData[3];

#if 1
			// read Acc Data
			mpu9250.readAccelData(accData);
        
			pc.printf("aX = %d,",*accData);
			pc.printf("aY = %d,",*(accData + 1));
			pc.printf("aZ = %d,",*(accData + 2));
			wait(1);
#endif
#if 1
			// read Gyro Data
			mpu9250.readGyroData(gyroData);
        
			pc.printf("gX = %d,",*gyroData);
			pc.printf("gY = %d,",*(gyroData + 1));
			pc.printf("gZ = %d,",*(gyroData + 2));
			wait(1);
#endif
#if 1				
			// read Magnetometer Data
			mpu9250.readMagData(magData);
        
			pc.printf("mX = %d,",*magData);
			pc.printf("mY = %d,",*(magData + 1));
			pc.printf("mZ = %d,",*(magData + 2));
			wait(1);
#endif	
    }
}
