#include "mbed.h"
#include "SDFileSystem.h"
#include "TextLCD.h"

SDFileSystem sd(PTE3, PTE1, PTE2, PTE4, "sd"); // MOSI, MISO, SCK, CS
Serial pc(PTC17,PTC16);
FILE *fp;

//New Declarations
DigitalOut myled(LED1);
InterruptIn sw2(SW2);

typedef struct temp{
    unsigned int DateTime;
    float temp1;
    float temp2;
    float temp3;
    float temp4;
    char In0;
    char In1;
    char In2;
    char In3;
    char Out0;
    char Out1;
    char Out2;
    char Out3;
    }TEMP_T;
#define TARGET_K64F 1

#ifdef TARGET_K64F
     TextLCD lcd(PTC12, PTC4, PTB23, PTA2, PTC2, PTC3);
    //TextLCD lcd( PTB9, PTA1, PTB23, PTA2, PTC2, PTC3); // LCD Shield for Arduino (DFR00009)
    AnalogIn button(PTB2);  // board button
    //PwmOut backlight(PTD0);
    DigitalOut backlight(PTD0);
#endif

void sw2_release(void)
{
    myled = !myled;
    lcd.cls();
    lcd.printf("button SW2 released.");
}


int file_copy(const char *src, const char *dst)
{
    int retval = 0;
    int ch;
    int count = 0;
    
        
    FILE *fpsrc = fopen(src, "r");   // src file
    FILE *fpdst = fopen(dst, "w");   // dest file
    
    while (1) {                  // Copy src to dest
        ch = fgetc(fpsrc);       // until src EOF read.
        if (ch == EOF) break;
        fputc(ch, fpdst);
    }
    fclose(fpsrc);
    fclose(fpdst);
  
    fpdst = fopen(dst, "r");     // Reopen dest to insure
    if (fpdst == NULL) {          // that it was created.
        retval = -1;           // Return error.
    } else {
        fclose(fpdst);
        retval = 0;              // Return success.
    }
    return retval;
}

uint32_t do_list(const char *fsrc)
{
    DIR *d = opendir(fsrc);
    struct dirent *p;
    uint32_t counter = 0;

    while ((p = readdir(d)) != NULL) {
        counter++;
        lcd.cls();
        lcd.printf("%s\r\n", p->d_name);
        wait(2);
    }
    closedir(d);
    return counter;
}

// bool is_folder(const char *fdir)
// {
//     DIR *dir = opendir(fdir);
//     if (dir) {
//         closedir(dir);
//     }
//     return (dir != NULL);

// }

// bool is_file(const char *ffile)
// {
//     FILE *fp = fopen(ffile, "r");
//     if (fp) {
//         fclose(fp);
//     }
//     return (fp != NULL);
// }

void do_remove(const char *fsrc)
{
    DIR *d = opendir(fsrc);
 // uint32_t ctr = 0;
    struct dirent *p = NULL;
    char path[30] = {0};
   
    
    if( d == NULL){
         return;
        }
    while((p = readdir(d)) != NULL) {
        strcpy(path, fsrc);
        strcat(path, "/");
        strcat(path, p->d_name);
        remove(path);
    }
    closedir(d);
    remove(fsrc);
}

 #define MAX_LOG_LINES 1000
 TEMP_T tmp_m;
 int curr_log_lines = 0;
 
 
 int Add_Log_to_file(TEMP_T *tmp)
 {
      
      fprintf(fp," %10u,%4.1f,%4.1f,%4.1f,%4.1f, %c, %c, %c, %c, %c, %c, %c, %c, \r\n",tmp->DateTime,  \
                                                                         tmp->temp1,  \
                                                                         tmp->temp2,     \
                                                                         tmp->temp3, \
                                                                         tmp->temp4,     \
                                                                         tmp->In0,\
                                                                         tmp->In1,\
                                                                         tmp->In2,\
                                                                         tmp->In3,\
                                                                         tmp->Out0,\
                                                                         tmp->Out1,\
                                                                         tmp->Out2,\
                                                                         tmp->Out3);
    if (curr_log_lines  > MAX_LOG_LINES ){
        fclose(fp);
        wait(0.1);
        fp = fopen("/sd/bmek/log.txt", "w");
        if (fp == NULL) {
            pc.printf("\r\nUnable to write the file \r\n");
            return -1;
        } else {
            fprintf(fp, "DateTime,Temp1,Temp2,Temp3,Temp4,In0,In1,In2,Out1,Out2,Out3,Out4,,\r\n");
        }                                 
                                                                     }
                                                                         
   return 0;                                                                       
 }
int main()
{
    backlight = 1;  // ON: 1, OFF: 0
    sw2.rise(&sw2_release);
    lcd.cls();
    lcd.printf("HEllo B-MeK");
    wait(3.5);
    pc.printf("\r\nInitializing \r\n");
    wait(2);

  
    if (do_list("/sd") == 0) {
        pc.printf("\r\nNo files/directories on the sd card.\r\n");
    }

    pc.printf("\r\nCreating test folder. \r\n");
    mkdir("/sd/bmek", 0777);
    

    fp = fopen("/sd/bmek/log.txt", "w");
    if (fp == NULL) {
        pc.printf("\r\nUnable to write the file \r\n");
    } else {
        fprintf(fp, "DateTime,Temp1,Temp2,Temp3,Temp4,In0,In1,In2,Out1,Out2,Out3,Out4,,\r\n");
        Add_Log_to_file(&tmp_m);
        Add_Log_to_file(&tmp_m);
        wait(5);
        fclose(fp);
        return 1;
    }

    //Display analogue and digital values on LCD
    
}
