#include "mbed.h"
#include "HIDScope.h"
#include "MODSERIAL.h"
#include "arm_math.h"

//Define objects
AnalogIn    emgB(PTB0); //Analog input bicep
AnalogIn    emgT(PTB1); //Analog input tricep

float filtered_emgB;
float filtered_emgT;
float MeanT2, MeanB1, MeanB2, MeanB3;
float filtered_emgT10_C, filtered_emgT11_C, filtered_emgT12_C, filtered_emgT13_C, filtered_emgT14_C, filtered_emgT15_C, filtered_emgT16_C, filtered_emgT17_C, filtered_emgT18_C, filtered_emgT19_C, filtered_emgT110_C, filtered_emgT111_C, filtered_emgT112_C, filtered_emgT113_C, filtered_emgT114_C, filtered_emgT115_C, filtered_emgT116_C, filtered_emgT117_C, filtered_emgT118_C, filtered_emgT119_C;
float B0, B1, B2, B3, B4, B5, B6, B7, B8, B9, MOVAVG_B;
float T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, MOVAVG_T;
float drempelwaardeB1, drempelwaardeB2, drempelwaardeB3, drempelwaardeT1, drempelwaardeT2;

MODSERIAL pc(USBTX,USBRX);

HIDScope scope(2);//uitgang scherm

arm_biquad_casd_df1_inst_f32 lowpass;
//constants for 50Hz lowpass
float lowpass_const[] = {0.2928920553, 0.5857841107, 0.2928920554, -0, -0.17156822136};//{a0 a1 a2 -b1 -b2} van online calculator
//state values
float lowpass_states[4];

arm_biquad_casd_df1_inst_f32 highpass;
//constants for 10Hz highpass
float highpass_const[] = {0.8005910267, -1.6011820533, 0.8005910267, 1.5610153913, -0.6413487154};//{a0 a1 a2 -b1 -b2}
//state values
float highpass_states[4];


/** Looper function
* functions used for Ticker and Timeout should be of type void <name>(void)
* i.e. no input arguments, no output arguments.
* if you want to change a variable that you use in other places (for example in main)
* you will have to make that variable global in order to be able to reach it both from
* the function called at interrupt time, and in the main function.
* To make a variable global, define it under the includes.
* variables that are changed in the interrupt routine (written to) should be made
* 'volatile' to let the compiler know that those values may change outside the current context.
* i.e.: "volatile uint16_t emg_value;" instead of "uint16_t emg_value"
* in the example below, the variable is not re-used in the main function, and is thus declared
* local in the looper function only.
**/

// Calibratie

void Calibratie()
{
    pc.printf("Calibratie drempelwaarde Triceps stand 1\n");
    wait(0.5);
    {
        int i;
        int j=19;

        for (i=0, i<=j; i++) {
            /*variable to store value in*/
            uint16_t emg_valueT1i_C;

            float emg_value_f32T1i_C;
            /*put raw emg value both in red and in emg_value*/
            emg_valueT1i_C = emgT1i_C.read_u16(); // read direct ADC result, converted to 16 bit integer (0..2^16 = 0..65536 = 0..3.3V)
            emg_value_f32T1i_C = emgT1i_C.read();

            //process emg
            arm_biquad_cascade_df1_f32(&highpass, &emg_value_f32T1i_C, &filtered_emgT1i_C, 1 );
            filtered_emgT1i_C = fabs(filtered_emgT1i_C);
            arm_biquad_cascade_df1_f32(&lowpass, &filtered_emgT1i_C, &filtered_emgT1i_C, 1 );
        }
    }
}

// Mean Triceps stand 1
void MeanTriceps()
{

    float MeanT1=filtered_emgT10_C*0.05+filtered_emgT11_C*0.05+filtered_emgT12_C*0.05+filtered_emgT13_C*0.05+filtered_emgT14_C*0.05+filtered_emgT15_C*0.05+filtered_emgT16_C*0.05+filtered_emgT17_C*0.05+filtered_emgT18_C*0.05+filtered_emgT19_C*0.05+filtered_emgT110_C*0.05+filtered_emgT111_C*0.05+filtered_emgT112_C*0.05+filtered_emgT113_C*0.05+filtered_emgT114_C*0.05+filtered_emgT115_C*0.05+filtered_emgT116_C*0.05+filtered_emgT117_C*0.05+filtered_emgT118_C*0.05+filtered_emgT119_C*0.05;

}

//BICEP EMG LEZEN
void looperB()
{
    /*variable to store value in*/
    uint16_t emg_valueB;

    float emg_value_f32B;
    /*put raw emg value both in red and in emg_value*/
    emg_valueB = emgB.read_u16(); // read direct ADC result, converted to 16 bit integer (0..2^16 = 0..65536 = 0..3.3V)
    emg_value_f32B = emgB.read();

    //process emg
    arm_biquad_cascade_df1_f32(&highpass, &emg_value_f32B, &filtered_emgB, 1 );
    filtered_emgB = fabs(filtered_emgB);
    arm_biquad_cascade_df1_f32(&lowpass, &filtered_emgB, &filtered_emgB, 1 );

    /*send value to PC. */
    scope.set(0,emg_valueB);     //uint value
    scope.set(1,filtered_emgB);  //processed float
    scope.send();

    // Moving Average Filter Biceps

    {
        B0=filtered_emgB;
        MOVAVG_B=B0*0.1+B1*0.1+B2*0.1+B3*0.1+B4*0.1+B5*0.1+B6*0.1+B7*0.1+B8*0.1+B9*0.1;
        B9=B8;
        B8=B7;
        B7=B6;
        B6=B5;
        B5=B4;
        B4=B3;
        B3=B2;
        B2=B1;
        B1=B0;
    }
}

// Triceps EMG lezen
void looperT()
{
    /*variable to store value in*/
    uint16_t emg_valueT;

    float emg_value_f32T;
    /*put raw emg value both in red and in emg_value*/
    emg_valueT = emgT.read_u16(); // read direct ADC result, converted to 16 bit integer (0..2^16 = 0..65536 = 0..3.3V)
    emg_value_f32T = emgT.read();

    //process emg
    arm_biquad_cascade_df1_f32(&highpass, &emg_value_f32T, &filtered_emgT, 1 );
    filtered_emgT = fabs(filtered_emgT);
    arm_biquad_cascade_df1_f32(&lowpass, &filtered_emgT, &filtered_emgT, 1 );

    /*send value to PC. */
    scope.set(2,emg_valueT);     //uint value
    scope.set(3,filtered_emgT);  //processed float
    scope.send();

    // Moving Average Filter Triceps
    {
        T0=filtered_emgT;
        MOVAVG_T=T0*0.1+T1*0.1+T2*0.1+T3*0.1+T4*0.1+T5*0.1+T6*0.1+T7*0.1+T8*0.1+T9*0.1;

        T9=T8;
        T8=T7;
        T7=T6;
        T6=T5;
        T5=T4;
        T4=T3;
        T3=T2;
        T2=T1;
        T1=T0;
    }
}

int main()
{
    Ticker log_timer,; //bicep logtimer
    //set up filters. Use external array for constants
    arm_biquad_cascade_df1_init_f32(&lowpass,1 , lowpass_const, lowpass_states);
    arm_biquad_cascade_df1_init_f32(&highpass,1 ,highpass_const, highpass_states);

    /**Here you attach the 'void looper(void)' function to the Ticker object
    * The looper() function will be called every 0.01 seconds.
    * Please mind that the parentheses after looper are omitted when using attach.
    */
    log_timer.attach(looperB, 0.005);//??
    while(1) { //Loop
        /*Empty!*/
        /*Everything is handled by the interrupt routine now!*/
    }
    
        Ticker log_timer,; //bicep logtimer
    //set up filters. Use external array for constants
    arm_biquad_cascade_df1_init_f32(&lowpass,1 , lowpass_const, lowpass_states);
    arm_biquad_cascade_df1_init_f32(&highpass,1 ,highpass_const, highpass_states);

    /**Here you attach the 'void looper(void)' function to the Ticker object
    * The looper() function will be called every 0.01 seconds.
    * Please mind that the parentheses after looper are omitted when using attach.
    */
    log_timer.attach(looperT, 0.005);//??
    while(1) { //Loop
        /*Empty!*/
        /*Everything is handled by the interrupt routine now!*/
    }
    
}

void AntwoordT()
{
    drempelwaardeT1=4.99;
    drempelwaardeT2=7;
    int yT1, yT2;

    if (MOVAVG_T > drempelwaardeT1) {
        yT1=1;
        if (MOVAVG_T > drempelwaardeT2) {
            yT2=1;
        } else {
            yT2=0;
        }
    } else {
        yT1=0;
    }

    int positie;

    positie=yT1+yT2;
    if (positie==0) {
        pc.printf("Motor 2 beweegt niet\n");
    } else {
        pc.printf("Motor 2 gaat beweegen\n");
    }
    if (positie==1) {
        pc.printf("Motor 2 beweegt naar positie 1\n");
    } else {
        pc.printf("Motor 1 beweegt niet naar positie 1\n");
    }
    if (positie==2) {
        pc.printf("Motor 1 beweegt naar positie 2\n");
    } else {
        pc.printf("Motor 1 beweegt niet naar positie 2\n");
    }
}

void AntwoordB()
{
    drempelwaardeB1=4.99;
    drempelwaardeB2=6;
    drempelwaardeB3=10;
    int yB1;
    int yB2;
    int yB3;

    if (MOVAVG_B > drempelwaardeB1) {
        yB1=1;
        if (MOVAVG_B > drempelwaardeB2) {
            yB2=1;
            if (MOVAVG_B > drempelwaardeB3) {
                yB3=1;
            } else {
                yB3=0;
            }
        } else {
            yB2=0;
        }
    } else {
        yB1=0;
    }

    int snelheidsstand;

    snelheidsstand=yB1+yB2+yB3;
    if (snelheidsstand==1) {
        pc.printf("Motor 1 beweegt met snelheid 1\n");
    } else {
        pc.printf("Motor 1 beweegt niet met snelheid 1\n");
    }
    if (snelheidsstand==2) {
        pc.printf("Motor 1 beweegt met snelheid 2\n");
    } else {
        pc.printf("Motor 1 beweegt niet met snelheid 2\n");
    }
    if (snelheidsstand==3) {
        pc.printf("Motor 1 beweegt met snelheid 3\n");
    } else {
        pc.printf("Motor 1 beweegt niet met snelheid 3\n");
    }
}
