#include "mbed.h"
#include "Servo.h"
#include <ros.h>
#include <std_msgs/Float32.h>

Servo myservo(PC_8);

ros::NodeHandle nh;
/////////////////////////////////////////////////////

DigitalOut led1(LED1);
//////////////////////////////////////////////////////
void servo_cb(const std_msgs::Float32& cmd_msg)
{
   myservo.position(cmd_msg.data);
}

//////////////////////////////////////////////////////
ros::Subscriber<std_msgs::Float32> sub("servo", servo_cb);

//////////////////////////////////////////////////////
int main()
{
    nh.initNode();
    nh.subscribe(sub);
    nh.getHardware()->setBaud(57600);
  
    while(1) {
    
        led1 = !led1;
        nh.spinOnce();       
    }
}
