#ifndef __NODECONFIG_H_
#define __NODECONFIG_H_

//#include <Arduino.h>
#include "RF24.h"


#define DEFAULT_NETWORK_PREFIX 0x424D45L    // All network node has a common 3 byte address prefix
#define DEFAULT_NODE_ADDRESS 0x424D455555L
#define DEFAULT_SYNC_ADDRESS 0x3333333333L
#define DEFAULT_GW_ID 0x0000
#define DEFAULT_RADIO_CHANNEL 96
#define DEFAULT_PA_LEVEL RF24_PA_MAX
#define DEFAULT_DATA_RATE RF24_2MBPS

class SSRadio;

class NodeConfig {
friend class SSRadio;

private:
    uint32_t netPrefix;
    uint16_t nodeId;
    uint16_t gwId;
    uint64_t syncAddress;

    uint8_t channel;            // Radio channel
    rf24_pa_dbm_e paLevel;      // PA level
    rf24_datarate_e dataRate;   // The transmission speed

    PinName cePin;         // CE pin
    PinName csnPin;        // CS pin

public:
    NodeConfig(PinName _cepin, PinName _cspin);

    void setNodeId(uint16_t nodeId);
    void setGwId(uint16_t gwId);
    void setNetPrefix(uint32_t netPrefix);
    void setSyncAddress(uint64_t syncAddress);
    void setChannel(uint8_t channel);
    void setSpeed(rf24_datarate_e dataRate);

    uint16_t getNodeId();   // Returns ID from EEPROM or UinqID. If no ID in EEPROM, then create one
};

#endif // NODECONFIG_H
