#include "NodeConfig.h"

#if defined(__AVR_ATmega328P__) 
#include <EEPROM.h>
#include "Entropy.h"
#endif

uint16_t NodeConfig::getNodeId() {

  uint16_t id;
  
  return id;
}

NodeConfig::NodeConfig(PinName cePin, PinName csnPin) {

    this->cePin = cePin;
    this->csnPin = csnPin;
    
    this->netPrefix = DEFAULT_NETWORK_PREFIX;
    this->syncAddress = DEFAULT_SYNC_ADDRESS;
    this->channel = DEFAULT_RADIO_CHANNEL;
    this->dataRate = DEFAULT_DATA_RATE;
    this->paLevel = DEFAULT_PA_LEVEL;
    this->nodeId = getNodeId();
    this->gwId = DEFAULT_GW_ID;
}

void NodeConfig::setChannel(uint8_t channel) {
    this->channel = channel;
}

void NodeConfig::setSpeed(rf24_datarate_e dataRate) {
    this->dataRate = dataRate;
}

void NodeConfig::setNetPrefix(uint32_t netPrefix) {
  this->netPrefix = netPrefix;
}

void NodeConfig::setNodeId(uint16_t nodeId) {
  this->nodeId = nodeId;
}

void NodeConfig::setGwId(uint16_t gwId) {
  this->gwId = gwId;
}

void NodeConfig::setSyncAddress(uint64_t syncAddress) {
    this->syncAddress = syncAddress;
}


