#include "mbed.h"
#include "MPU9250Mod.h"
#include "RF24.h"


#define NodeID      1


#define ledpin      PA_10

#define nrf_CE      PA_1
#define nrf_CSN     PA_4
#define spi_SCK     PA_5
#define spi_MOSI    PA_7
#define spi_MISO    PA_6
#define nrf_irq     PA_1 

#define i2c_sda     PF_0
#define i2c_scl     PF_1

MPU9250 mpu9250;
DigitalOut led(ledpin);

RF24 radio(spi_MOSI, spi_MISO, spi_SCK, nrf_CE, nrf_CSN );
InterruptIn NRF_irq(PA_0);

const uint64_t PiAddress =  0xF0F0F0F0E1LL; 
const uint64_t ActionAddress = 0xF0F0F0F0D2LL;


struct IRQStruct{
    uint8_t ID;
    uint8_t Threshold;
    bool isOn;
}IRQMsg;

void RF24IntHandler();
void SetupRadio();
void SendMsg();

float AccelMsg = 1.0;
uint8_t AThreshold = 5;

typedef enum{
    NRF,
    IMU
} state;

state State = IMU;


int main(){
    led = !led;
    SetupRadio();
    
    NRF_irq.fall(&RF24IntHandler);
    
    
    
    i2c.frequency(400000);
    mpu9250.initMPU9250(); 
    
    
    mpu9250.getAres(); // Get accelerometer sensitivity
    mpu9250.getGres(); // Get gyro sensitivity
    mpu9250.getMres(); // Get magnetometer sensitivity
    
    while(true){
        
        switch(State){
            case(IMU):
                    if(mpu9250.readByte(MPU9250_ADDRESS, INT_STATUS) & 0x01){ 
                        mpu9250.readAccelData(accelCount);
                        ax = (float)accelCount[0]*aRes;
                        ay = (float)accelCount[1]*aRes;
                        az = (float)accelCount[2]*aRes;
                       
                        float AbsAcc = sqrt(ax*ax + ay*ay + az*az);
                        AccelMsg = AbsAcc;
                        //memcpy(&AccelMsg, &AbsAcc, 4);
                       
                        if(AbsAcc > AThreshold)
                            SendMsg();
                    }
                    
                    wait(0.1);
                
                
                break;
                
            case(NRF):
                    if(radio.getDynamicPayloadSize() < 1)// Corrupt payload has been flushed
                        continue; 
            
                    radio.read(&IRQMsg, sizeof(IRQMsg));
        
                    if(IRQMsg.ID != NodeID)
                        continue;
                        
                    led = IRQMsg.isOn;
                    AThreshold = IRQMsg.Threshold;
                    
                    State = IMU;
                
                break;
        }
        
        
        
        
        
           
            
            
                
    }
}

void SendMsg(){
    radio.stopListening();
    wait_ms(10);
    
    
    radio.write(&AccelMsg, sizeof(AccelMsg) );
    radio.startListening();
    led = !led;
    wait(1);
    
}

void SetupRadio(){
    
    radio.begin();
    radio.setPALevel(RF24_PA_MAX) ;
    radio.setDataRate(RF24_2MBPS);
    radio.setCRCLength(RF24_CRC_16);
    radio.setChannel(120);
    
    radio.enableDynamicAck();
    radio.enableDynamicPayloads();
    
    radio.openWritingPipe(ActionAddress);
    radio.openReadingPipe(1,PiAddress);
    
    radio.startListening();
    
}



void RF24IntHandler(){
     State = NRF;
    
    
}