#include <mbed.h>
#include "DeviceHubNet.h"

Serial pc(PB_6, PB_7);
DigitalOut led(PA_8);

// Here is your project settings
// Projecty ID, APIkey, Device ID
// Get your own IDs from the DeviceHub.net site
DeviceHubNet DHN(4275, "bbbb950b-ad0c-4fcd-8f0a-546e154a1c35", "40854b01-0ff4-407f-bc63-fa75f6604ec4");

// This one is a callback function, you can set up with the actuator
// The type will tell you the type of the data as 0: digital, 1: float
// According to the type, only ddata OR adata is valid. The other is 0.
void onLightSwitchMsg(uint8_t type, uint8_t ddata, float adata)
{
    pc.printf("Data received. Type: %d\n\r", type);
    pc.printf("Switching light: %d\n\r", ddata);
}

int main()
{
    led = 1;
    wait_ms(2000);

    // Here you set the radio communication parameters
    // First the pins, which the radio modul uses
    // Parameters: SPI_MOSI, SPI_MISO, SPI_SCK, CS, CE

    //DHN.radioPinConfig(SPI_MOSI, SPI_MISO, SPI_SCK, PB_4, PB_3);  
    DHN.radioPinConfig(PA_7, PA_6, PA_5, PB_3, PB_4);
    
    // Second the ID and the channel
    // Parameters: Unique ID (0-65535), channel (0-127) 
    DHN.radioConfig(0x1234, 100);

    pc.printf("DeviceHubNet DEMO started.\n\r\n\r");
    
    // Dumps the configuration
    // If all 0 or anything weired, the the configuration was wrong
    DHN.radioDump();

    //uint16_t delay = DHN.radioPing();
    //pc.printf("Ping delay: %d", delay);


    // Registers your sensor. Name should match with the DHN's sensor name
    // The returned ID can be used for data sending
    uint16_t sid = DHN.registerSensor("LightSense");
    pc.printf("Sensor registered. %d\n\r", sid);
    
    // Registers your actuator. Name should match with the DHN's actuator name
    // Type of the actuator should be set here. 0: digital (0-1), 1: analog (float)
    // You should define a callback function for the data
    // Parameters: name, type, callback
    uint16_t aid = DHN.registerActuator("LightSwitch", 0, &onLightSwitchMsg);
    pc.printf("Actuator registered. %d\n\r", aid);

    while (1) {
        
        // Message processing. Must be called frequently in order to receiver actuator messages
        DHN.processMsgs();
        
        // Send sensor data
        DHN.sendDigitalData(sid, 1);
        wait_ms(500);
        led = ! led;
        DHN.sendAnalogData(sid, 3.14);
        wait_ms(200);
        led = ! led;
    }

}