#include "mbed.h"
#include "DeafNode.h"

AnalogIn adc0(A0);
AnalogIn adc1(A1);
AnalogIn adc2(A2);
AnalogIn adc3(A3);
AnalogIn adc4(A4);
//AnalogIn adc5(A5);
//AnalogIn adc5(D0);

DigitalOut led(D3);
DeafNode *deafNode;
Serial pc(USBTX, USBRX);

#define SAMPLE_SIZE 960
#define PRESAMPLE_SIZE 60
// Buffers to store the samples of the 6 channels
uint8_t buffer0[SAMPLE_SIZE];
uint8_t buffer1[SAMPLE_SIZE];
uint8_t buffer2[SAMPLE_SIZE];
uint8_t buffer3[SAMPLE_SIZE];
uint8_t buffer4[SAMPLE_SIZE];
//uint8_t buffer5[SAMPLE_SIZE];


uint8_t sid;
int sample_start;
int sample_size;
int sample_pointer;

#define DCVAL 118
#define THRESHOLD 34

uint8_t datapacket[32];

volatile unsigned int TickCount;
extern "C" void SysTick_Handler (void)
{
    TickCount+= 1;
}

void readMics()
{
    buffer0[sample_pointer] = adc0.read_u16() >> 8;
    buffer1[sample_pointer] = adc1.read_u16() >> 8;
    buffer2[sample_pointer] = adc2.read_u16() >> 8;
    buffer3[sample_pointer] = adc3.read_u16() >> 8;
    buffer4[sample_pointer] = adc4.read_u16() >> 8;
//    buffer5[sample_pointer] = adc5.read_u16() >> 8;
    
    //buffer0[sample_pointer] = 120;
    //buffer1[sample_pointer] = 121;
    //buffer2[sample_pointer] = 122;
    //buffer3[sample_pointer] = 123;
    //buffer4[sample_pointer] = 124;
    //buffer5[sample_pointer] = 125;
}

bool checkThreshold()
{
    bool threshold = false;

    if (buffer0[sample_pointer] > DCVAL + THRESHOLD || buffer0[sample_pointer] < DCVAL - THRESHOLD) threshold = true;
    else if (buffer1[sample_pointer] > DCVAL + THRESHOLD || buffer1[sample_pointer] < DCVAL - THRESHOLD) threshold = true;
    else if (buffer2[sample_pointer] > DCVAL + THRESHOLD || buffer2[sample_pointer] < DCVAL - THRESHOLD) threshold = true;
    else if (buffer3[sample_pointer] > DCVAL + THRESHOLD || buffer3[sample_pointer] < DCVAL - THRESHOLD) threshold = true;
    else if (buffer4[sample_pointer] > DCVAL + THRESHOLD || buffer4[sample_pointer] < DCVAL - THRESHOLD) threshold = true;
 //   else if (buffer5[sample_pointer] > DCVAL + THRESHOLD || buffer5[sample_pointer] < DCVAL - THRESHOLD) threshold = true;

    return threshold;
}

void sendSamples(uint8_t sid, uint8_t mid, uint8_t *samples, int length, int pointer)
{
    // 0-1 bytes: type ID
    datapacket[0] = 0x00;
    datapacket[1] = 0x11;
    datapacket[2] = sid << 4 | mid & 0x0f;

    int c = 0;
    while (c < length) {
        int j;
        // 2-3 bytes: 4 bit sample ID, 12 bit offset (in 20 bytes)
        
        datapacket[3] = (c / 20);
        for (j = 0; j < 20; j++) {
            datapacket[4 + j] = samples[pointer];
            pointer++;
            if (pointer >= SAMPLE_SIZE) pointer = 0;
            c++;
            if (c > length) break;
        }
        deafNode->sendData(0, datapacket, j + 4);
    }
}

int main()
{
    led = 0;
    SysTick_Config(SystemCoreClock / 1000); // Systick in ms

    pc.baud(115200);
    pc.printf("Node started (%d MHz).\n", SystemCoreClock / 1000000);

    NodeConfig nc;
    nc.address = 0x4D31;
    nc.netprefix = 0x424D45L;
    nc.radioCE = D9;
    nc.radioCS = D10;
    nc.spi_sck = SPI_SCK;
    nc.spi_miso = SPI_MISO;
    nc.spi_mosi = SPI_MOSI;
    nc.radioChannel = 96;
    nc.radioSpeed = RF24_2MBPS;

    deafNode = new DeafNode(&nc);
    deafNode->setup();

    if (deafNode->isRadioWorking()) {
        pc.printf("Radio is working.\n");
        led = 1;
    }
    sid = 0;
    sample_start = 0;
    sample_size = 0;
    sample_pointer = 0;

    bool action = false;

    while(1) {

        readMics();
        //pc.puts(".");

        if (!action) {
            // Not in action, just listening
            if (checkThreshold()) {
                //pc.puts("\nThreshold reached!\n");
                action = true;
                if (sample_size > PRESAMPLE_SIZE) {
                    sample_size = PRESAMPLE_SIZE;
                }
                sample_start = sample_pointer - sample_size;
                if (sample_start < 0) sample_start += SAMPLE_SIZE;
            }
            sample_pointer++;
            if (sample_pointer >= SAMPLE_SIZE) sample_pointer = 0;
            if (sample_size < SAMPLE_SIZE) sample_size++;
        } else {
            // In action, collecting
            sample_pointer++;
            if (sample_pointer >= SAMPLE_SIZE) sample_pointer = 0;
            sample_size++;
            if (sample_size == SAMPLE_SIZE) {
                // Stop collecting, send samples
                action = false;
                for (int r = 1; r <= 2; r++) {
                    sendSamples(sid, 0, buffer0, SAMPLE_SIZE, sample_start);
                    sendSamples(sid, 1, buffer1, SAMPLE_SIZE, sample_start);
                    sendSamples(sid, 2, buffer2, SAMPLE_SIZE, sample_start);
                    sendSamples(sid, 3, buffer3, SAMPLE_SIZE, sample_start);
                    sendSamples(sid, 4, buffer4, SAMPLE_SIZE, sample_start);
//                    sendSamples(sid, 5, buffer5, SAMPLE_SIZE, sample_start);
                    printf("\nSamples were sent (%d).\n", r);
                }
                sid++;
                sample_size = 0;
                sample_pointer = 0;
            }
        }
    }
}
