#ifndef _ROS_s_rov_msgs_s_rov_state_h
#define _ROS_s_rov_msgs_s_rov_state_h

#include <stdint.h>
#include <string.h>
#include <stdlib.h>
#include "ros/msg.h"

namespace s_rov_msgs
{

  class s_rov_state : public ros::Msg
  {
    public:
      float Voltage;
      float Current;

    s_rov_state():
      Voltage(0),
      Current(0)
    {
    }

    virtual int serialize(unsigned char *outbuffer) const
    {
      int offset = 0;
      union {
        float real;
        uint32_t base;
      } u_Voltage;
      u_Voltage.real = this->Voltage;
      *(outbuffer + offset + 0) = (u_Voltage.base >> (8 * 0)) & 0xFF;
      *(outbuffer + offset + 1) = (u_Voltage.base >> (8 * 1)) & 0xFF;
      *(outbuffer + offset + 2) = (u_Voltage.base >> (8 * 2)) & 0xFF;
      *(outbuffer + offset + 3) = (u_Voltage.base >> (8 * 3)) & 0xFF;
      offset += sizeof(this->Voltage);
      union {
        float real;
        uint32_t base;
      } u_Current;
      u_Current.real = this->Current;
      *(outbuffer + offset + 0) = (u_Current.base >> (8 * 0)) & 0xFF;
      *(outbuffer + offset + 1) = (u_Current.base >> (8 * 1)) & 0xFF;
      *(outbuffer + offset + 2) = (u_Current.base >> (8 * 2)) & 0xFF;
      *(outbuffer + offset + 3) = (u_Current.base >> (8 * 3)) & 0xFF;
      offset += sizeof(this->Current);
      return offset;
    }

    virtual int deserialize(unsigned char *inbuffer)
    {
      int offset = 0;
      union {
        float real;
        uint32_t base;
      } u_Voltage;
      u_Voltage.base = 0;
      u_Voltage.base |= ((uint32_t) (*(inbuffer + offset + 0))) << (8 * 0);
      u_Voltage.base |= ((uint32_t) (*(inbuffer + offset + 1))) << (8 * 1);
      u_Voltage.base |= ((uint32_t) (*(inbuffer + offset + 2))) << (8 * 2);
      u_Voltage.base |= ((uint32_t) (*(inbuffer + offset + 3))) << (8 * 3);
      this->Voltage = u_Voltage.real;
      offset += sizeof(this->Voltage);
      union {
        float real;
        uint32_t base;
      } u_Current;
      u_Current.base = 0;
      u_Current.base |= ((uint32_t) (*(inbuffer + offset + 0))) << (8 * 0);
      u_Current.base |= ((uint32_t) (*(inbuffer + offset + 1))) << (8 * 1);
      u_Current.base |= ((uint32_t) (*(inbuffer + offset + 2))) << (8 * 2);
      u_Current.base |= ((uint32_t) (*(inbuffer + offset + 3))) << (8 * 3);
      this->Current = u_Current.real;
      offset += sizeof(this->Current);
     return offset;
    }

    const char * getType(){ return "s_rov_msgs/s_rov_state"; };
    const char * getMD5(){ return "e2848ca8a25ac096219c461e07bcd312"; };

  };

}
#endif