#ifndef _ROS_s_rov_msgs_s_rov_control_esc_h
#define _ROS_s_rov_msgs_s_rov_control_esc_h

#include <stdint.h>
#include <string.h>
#include <stdlib.h>
#include "ros/msg.h"

namespace s_rov_msgs
{

  class s_rov_control_esc : public ros::Msg
  {
    public:
      float escPWM[4];
      bool escSwitch;

    s_rov_control_esc():
      escPWM(),
      escSwitch(0)
    {
    }

    virtual int serialize(unsigned char *outbuffer) const
    {
      int offset = 0;
      for( uint32_t i = 0; i < 4; i++){
      union {
        float real;
        uint32_t base;
      } u_escPWMi;
      u_escPWMi.real = this->escPWM[i];
      *(outbuffer + offset + 0) = (u_escPWMi.base >> (8 * 0)) & 0xFF;
      *(outbuffer + offset + 1) = (u_escPWMi.base >> (8 * 1)) & 0xFF;
      *(outbuffer + offset + 2) = (u_escPWMi.base >> (8 * 2)) & 0xFF;
      *(outbuffer + offset + 3) = (u_escPWMi.base >> (8 * 3)) & 0xFF;
      offset += sizeof(this->escPWM[i]);
      }
      union {
        bool real;
        uint8_t base;
      } u_escSwitch;
      u_escSwitch.real = this->escSwitch;
      *(outbuffer + offset + 0) = (u_escSwitch.base >> (8 * 0)) & 0xFF;
      offset += sizeof(this->escSwitch);
      return offset;
    }

    virtual int deserialize(unsigned char *inbuffer)
    {
      int offset = 0;
      for( uint32_t i = 0; i < 4; i++){
      union {
        float real;
        uint32_t base;
      } u_escPWMi;
      u_escPWMi.base = 0;
      u_escPWMi.base |= ((uint32_t) (*(inbuffer + offset + 0))) << (8 * 0);
      u_escPWMi.base |= ((uint32_t) (*(inbuffer + offset + 1))) << (8 * 1);
      u_escPWMi.base |= ((uint32_t) (*(inbuffer + offset + 2))) << (8 * 2);
      u_escPWMi.base |= ((uint32_t) (*(inbuffer + offset + 3))) << (8 * 3);
      this->escPWM[i] = u_escPWMi.real;
      offset += sizeof(this->escPWM[i]);
      }
      union {
        bool real;
        uint8_t base;
      } u_escSwitch;
      u_escSwitch.base = 0;
      u_escSwitch.base |= ((uint8_t) (*(inbuffer + offset + 0))) << (8 * 0);
      this->escSwitch = u_escSwitch.real;
      offset += sizeof(this->escSwitch);
     return offset;
    }

    const char * getType(){ return "s_rov_msgs/s_rov_control_esc"; };
    const char * getMD5(){ return "29b94efb4e96b7ab876134acfa0a6e69"; };

  };

}
#endif