#ifndef _ROS_s_rov_msgs_s_rov_control_led_h
#define _ROS_s_rov_msgs_s_rov_control_led_h

#include <stdint.h>
#include <string.h>
#include <stdlib.h>
#include "ros/msg.h"

namespace s_rov_msgs
{

  class s_rov_control_led : public ros::Msg
  {
    public:
      float ledPWM[2];

    s_rov_control_led():
      ledPWM()
    {
    }

    virtual int serialize(unsigned char *outbuffer) const
    {
      int offset = 0;
      for( uint32_t i = 0; i < 2; i++){
      union {
        float real;
        uint32_t base;
      } u_ledPWMi;
      u_ledPWMi.real = this->ledPWM[i];
      *(outbuffer + offset + 0) = (u_ledPWMi.base >> (8 * 0)) & 0xFF;
      *(outbuffer + offset + 1) = (u_ledPWMi.base >> (8 * 1)) & 0xFF;
      *(outbuffer + offset + 2) = (u_ledPWMi.base >> (8 * 2)) & 0xFF;
      *(outbuffer + offset + 3) = (u_ledPWMi.base >> (8 * 3)) & 0xFF;
      offset += sizeof(this->ledPWM[i]);
      }
      return offset;
    }

    virtual int deserialize(unsigned char *inbuffer)
    {
      int offset = 0;
      for( uint32_t i = 0; i < 2; i++){
      union {
        float real;
        uint32_t base;
      } u_ledPWMi;
      u_ledPWMi.base = 0;
      u_ledPWMi.base |= ((uint32_t) (*(inbuffer + offset + 0))) << (8 * 0);
      u_ledPWMi.base |= ((uint32_t) (*(inbuffer + offset + 1))) << (8 * 1);
      u_ledPWMi.base |= ((uint32_t) (*(inbuffer + offset + 2))) << (8 * 2);
      u_ledPWMi.base |= ((uint32_t) (*(inbuffer + offset + 3))) << (8 * 3);
      this->ledPWM[i] = u_ledPWMi.real;
      offset += sizeof(this->ledPWM[i]);
      }
     return offset;
    }

    const char * getType(){ return "s_rov_msgs/s_rov_control_led"; };
    const char * getMD5(){ return "b1fb200946fca2f8d28e4b9bda55f10b"; };

  };

}
#endif