#ifndef _PCA9685_H_
#define _PCA9685_H_

#include "mbed.h"

#define PCA9685_MODE1       0x00
#define PCA9685_MODE2       0x01
#define PCA9685_PRESCALE    0xFE
#define PCA9685_LED0_ON_L   0x06
#define PCA9685_CLOCK   25000000

class PCA9685{
    public:
        PCA9685(uint8_t i2c_addr, I2C* i2c_object, float freq); 
        void reset(void);
        void init(void);
        void set_pwm_frequency(float freq);
        void set_pwm_output(uint8_t num, uint16_t on, uint16_t off);
        void set_pwm_duty(uint8_t num, float duty);
        void set_servo_angle(uint8_t num, float angle);
        void write_8(uint8_t reg, uint8_t msg);
        char read_8(uint8_t reg);
    
    private:
        uint8_t PCA9685_ADDR;
        float frequency;
        I2C* i2c;
    
};

#endif