#include "ads1015.h"

ADS1015::ADS1015(uint8_t i2c_addr, I2C* i2c_object, uint16_t adc_gain):
    ADS1015_ADDR(i2c_addr << 1),
    i2c(i2c_object),
    m_gain(adc_gain)
{}

uint16_t ADS1015::read_single_channel(int ch){
    if(ch > 3)
        return 0;
        
    uint16_t config = ADS1015_CONFIG_COMP_QUE_NONE    | // disable comparator
                      ADS1015_CONFIG_COMP_LAT_NONE    | // nonlatching comparator
                      ADS1015_CONFIG_COMP_POL_ACTVLOW | // Alert/Rdy active low
                      ADS1015_CONFIG_COMP_MODE_TRAD           | // Traditional comparator
                      ADS1015_CONFIG_DR_1600SPS       | // Data rate : 1600sps
                      ADS1015_CONFIG_MODE_SINGLE      | // Single shot mode
                      m_gain;                           // Set gain
                      
    switch(ch){
        case 0 :
            config |= ADS1015_CONFIG_MUX_SINGLE_0;
            break;
        case 1 :
            config |= ADS1015_CONFIG_MUX_SINGLE_1;
            break;
        case 2 :
            config |= ADS1015_CONFIG_MUX_SINGLE_2;
            break;
        case 3 :
            config |= ADS1015_CONFIG_MUX_SINGLE_3;
            break;                      
    }
    
    config |= ADS1015_CONFIG_OS_START_CONV;
    
    write_16(ADS1015_REG_CONFIG, config);
    wait_ms(ADS1015_CONVERSIONDELAY);
    return read_16(ADS1015_REG_CONVERSION) >> 4;                          
}

void ADS1015::write_16(uint8_t reg, uint16_t msg){
    char cmd[3];
    cmd[0] = reg;
    cmd[1] = (char)(msg>>8);
    cmd[2] = (char)(msg & 0xff);

    i2c->write(ADS1015_ADDR, cmd, 3);
}

uint16_t ADS1015::read_16(uint8_t reg){
    char cmd[2];
    cmd[0] = reg;
    i2c->write(ADS1015_ADDR, cmd, 1);
    i2c->read(ADS1015_ADDR, cmd, 2);
    return (cmd[0] << 8 | cmd[1]);    
}