#ifndef _ADS1015_H_
#define _ADS1015_H_

#include "mbed.h"

/*=============================================================================

Conversion delay (in ms)

=============================================================================*/
#define ADS1015_CONVERSIONDELAY 1

/*=============================================================================

Register Map

=============================================================================*/
#define ADS1015_REG_CONVERSION  0x00
#define ADS1015_REG_CONFIG      0x01
#define ADS1015_REG_LOWTHRESH   0x02
#define ADS1015_REG_HITHRESH    0X03

/*=============================================================================

Config Register Field Descriptions

=============================================================================*/
#define ADS1015_CONFIG_OS_START_CONV    0x8000

#define ADS1015_CONFIG_MUX_DIFF_0_1     0x0000
#define ADS1015_CONFIG_MUX_DIFF_0_3     0x1000
#define ADS1015_CONFIG_MUX_DIFF_1_3     0x2000
#define ADS1015_CONFIG_MUX_DIFF_2_3     0x3000
#define ADS1015_CONFIG_MUX_SINGLE_0     0X4000
#define ADS1015_CONFIG_MUX_SINGLE_1     0x5000
#define ADS1015_CONFIG_MUX_SINGLE_2     0x6000
#define ADS1015_CONFIG_MUX_SINGLE_3     0x7000

#define ADS1015_CONFIG_MODE_CONT        0x0000
#define ADS1015_CONFIG_MODE_SINGLE      0x0100

#define ADS1015_CONFIG_DR_128SPS        0x0000
#define ADS1015_CONFIG_DR_250SPS        0x0020
#define ADS1015_CONFIG_DR_490SPS        0x0040
#define ADS1015_CONFIG_DR_920SPS        0x0060
#define ADS1015_CONFIG_DR_1600SPS       0x0080
#define ADS1015_CONFIG_DR_2400SPS       0x00A0
#define ADS1015_CONFIG_DR_3300SPS       0x00C0

#define ADS1015_CONFIG_COMP_MODE_TRAD   0x0000
#define ADS1015_CONFIG_COMP_MODE_WINDOW 0x0010

#define ADS1015_CONFIG_COMP_POL_ACTVLOW 0x0000
#define ADS1015_CONFIG_COMP_POL_ACTVHI  0x0008

#define ADS1015_CONFIG_COMP_LAT_NONE    0x0000
#define ADS1015_CONFIG_COMP_LAT_LATCH   0x0004

#define ADS1015_CONFIG_COMP_QUE_1CONV   0x0000
#define ADS1015_CONFIG_COMP_QUE_2CONV   0X0001
#define ADS1015_CONFIG_COMP_QUE_4CONV   0x0002
#define ADS1015_CONFIG_COMP_QUE_NONE    0x0003

/*=============================================================================

GAIN

=============================================================================*/
#define ADS1015_GAIN_TWOTHRIDS  0x0000
#define ADS1015_GAIN_ONE        0x0200
#define ADS1015_GAIN_TWO        0x0400
#define ADS1015_GAIN_FOUR       0x0600
#define ADS1015_GAIN_EIGHT      0x0800
#define ADS1015_GAIN_SIXTEEN    0x0A00

class ADS1015{
    public:
        ADS1015(uint8_t i2c_addr, I2C* i2c_object, uint16_t adc_gain); 
        uint16_t read_single_channel(int ch);
        void write_16(uint8_t reg, uint16_t msg);
        uint16_t read_16(uint8_t reg);
    
    private:
        uint8_t ADS1015_ADDR;
        I2C* i2c;
        uint16_t m_gain;
};

#endif