#ifndef NEOPIXEL_ARRAY_H
#define NEOPIXEL_ARRAY_H
#include "mbed.h"

/*
Template for array literals

const uint8_t arr[8][8][3] = {\
{ {000,000,000} , {000,000,000} , {000,000,000} , {000,000,000} , {000,000,000} , {000,000,000} , {000,000,000} , {000,000,000} } ,\
{ {000,000,000} , {000,000,000} , {000,000,000} , {000,000,000} , {000,000,000} , {000,000,000} , {000,000,000} , {000,000,000} } ,\
{ {000,000,000} , {000,000,000} , {000,000,000} , {000,000,000} , {000,000,000} , {000,000,000} , {000,000,000} , {000,000,000} } ,\
{ {000,000,000} , {000,000,000} , {000,000,000} , {000,000,000} , {000,000,000} , {000,000,000} , {000,000,000} , {000,000,000} } ,\
{ {000,000,000} , {000,000,000} , {000,000,000} , {000,000,000} , {000,000,000} , {000,000,000} , {000,000,000} , {000,000,000} } ,\
{ {000,000,000} , {000,000,000} , {000,000,000} , {000,000,000} , {000,000,000} , {000,000,000} , {000,000,000} , {000,000,000} } ,\
{ {000,000,000} , {000,000,000} , {000,000,000} , {000,000,000} , {000,000,000} , {000,000,000} , {000,000,000} , {000,000,000} } ,\
{ {000,000,000} , {000,000,000} , {000,000,000} , {000,000,000} , {000,000,000} , {000,000,000} , {000,000,000} , {000,000,000} } \
};

*/

void showArray1(neopixel_strip_t *strip, const uint8_t arr[8][8][3], double scalingFactor)
{
    for (int j=0; j<8; j++)
    {
        for (int i=0; i<8; i++)
        {
            neopixel_set_color(strip, i+j*8, arr[j][i][0]*scalingFactor, arr[j][i][1]*scalingFactor, arr[j][i][2]*scalingFactor);
        }
    }
    neopixel_show(strip);
}

void showArray2(neopixel_strip_t *strip, const uint8_t arr[16][8][3], double scalingFactor)
{
    for (int i=0; i<16; i++)
    {
        for (int j=0; j<8; j++)
        {
            neopixel_set_color(strip,j+8*i,arr[i][j][0]*scalingFactor,arr[i][j][1]*scalingFactor,arr[i][j][2]*scalingFactor);
        }
    }
    neopixel_show(strip);
}

const uint8_t flag_usa[8][8][3] = {\
{{0,0,255} , {0,0,255} , {0,0,255} , {0,0,255} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0}} ,\
{{0,0,255} , {0,0,255} , {0,0,255} , {0,0,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255}} ,\
{{0,0,255} , {0,0,255} , {0,0,255} , {0,0,255} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} },\
{{0,0,255} , {0,0,255} , {0,0,255} , {0,0,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255}} ,\
{{255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0}} ,\
{{255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} },\
{{255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} },\
{{255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} }\
};

    
const uint8_t arrow_up_red[8][8][3] = {\
{{0,0,0} , {0,0,0} , {0,0,0} , {255,0,0} , {255,0,0} , {0,0,0} , {0,0,0} , {0,0,0} },\
{{0,0,0} , {0,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {0,0,0} , {0,0,0} },\
{{0,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {0,0,0} },\
{{255,0,0} , {255,0,0} , {0,0,0} , {255,0,0} , {255,0,0} , {0,0,0} , {255,0,0} , {255,0,0} },\
{{255,0,0} , {0,0,0} , {0,0,0} , {255,0,0} , {255,0,0} , {0,0,0} , {0,0,0} , {255,0,0} },\
{{0,0,0} , {0,0,0} , {0,0,0} , {255,0,0} , {255,0,0} , {0,0,0} , {0,0,0} , {0,0,0} },\
{{0,0,0} , {0,0,0} , {0,0,0} , {255,0,0} , {255,0,0} , {0,0,0} , {0,0,0} , {0,0,0} },\
{{0,0,0} , {0,0,0} , {0,0,0} , {255,0,0} , {255,0,0} , {0,0,0} , {0,0,0} , {0,0,0} }\
};

    
const uint8_t arrow_right_red[8][8][3] = {\
{{0,0,0} , {0,0,0} , {0,0,0} , {255,0,0} , {255,0,0} , {0,0,0} , {0,0,0} , {0,0,0} },\
{{0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {255,0,0} , {255,0,0} , {0,0,0} , {0,0,0} },\
{{0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {255,0,0} , {255,0,0} , {0,0,0} },\
{{255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} },\
{{255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} },\
{{0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {255,0,0} , {255,0,0} , {0,0,0} },\
{{0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {255,0,0} , {255,0,0} , {0,0,0} , {0,0,0} },\
{{0,0,0} , {0,0,0} , {0,0,0} , {255,0,0} , {255,0,0} , {0,0,0} , {0,0,0} , {0,0,0} }\
};

    
const uint8_t arrow_down_red[8][8][3] = {\
{{0,0,0} , {0,0,0} , {0,0,0} , {255,0,0} , {255,0,0} , {0,0,0} , {0,0,0} , {0,0,0} },\
{{0,0,0} , {0,0,0} , {0,0,0} , {255,0,0} , {255,0,0} , {0,0,0} , {0,0,0} , {0,0,0} },\
{{0,0,0} , {0,0,0} , {0,0,0} , {255,0,0} , {255,0,0} , {0,0,0} , {0,0,0} , {0,0,0} },\
{{255,0,0} , {0,0,0} , {0,0,0} , {255,0,0} , {255,0,0} , {0,0,0} , {0,0,0} , {255,0,0} },\
{{255,0,0} , {255,0,0} , {0,0,0} , {255,0,0} , {255,0,0} , {0,0,0} , {255,0,0} , {255,0,0} },\
{{0,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {0,0,0} },\
{{0,0,0} , {0,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {0,0,0} , {0,0,0} },\
{{0,0,0} , {0,0,0} , {0,0,0} , {255,0,0} , {255,0,0} , {0,0,0} , {0,0,0} , {0,0,0} }\
};
    
const uint8_t arrow_left_red[8][8][3] = {\
{ {0,0,0} , {0,0,0} , {0,0,0} , {255,0,0} , {255,0,0} , {0,0,0} , {0,0,0} , {0,0,0} },\
{ {0,0,0} , {0,0,0} , {255,0,0} , {255,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} },\
{ {0,0,0} , {255,0,0} , {255,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} },\
{ {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} },\
{ {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} },\
{ {0,0,0} , {255,0,0} , {255,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} },\
{ {0,0,0} , {0,0,0} , {255,0,0} , {255,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} },\
{ {0,0,0} , {0,0,0} , {0,0,0} , {255,0,0} , {255,0,0} , {0,0,0} , {0,0,0} , {0,0,0} }\
};

const uint8_t arrow_up_green[8][8][3] = {\
{ {0,0,0} , {0,0,0} , {0,0,0} , {0,255,0} , {0,255,0} , {0,0,0} , {0,0,0} , {0,0,0} } ,\
{ {0,0,0} , {0,0,0} , {0,255,0} , {0,255,0} , {0,255,0} , {0,255,0} , {0,0,0} , {0,0,0} } ,\
{ {0,0,0} , {0,255,0} , {0,255,0} , {0,255,0} , {0,255,0} , {0,255,0} , {0,255,0} , {0,0,0} } ,\
{ {0,255,0} , {0,255,0} , {0,0,0} , {0,255,0} , {0,255,0} , {0,0,0} , {0,255,0} , {0,255,0} } ,\
{ {0,255,0} , {0,0,0} , {0,0,0} , {0,255,0} , {0,255,0} , {0,0,0} , {0,0,0} , {0,255,0} } ,\
{ {0,0,0} , {0,0,0} , {0,0,0} , {0,255,0} , {0,255,0} , {0,0,0} , {0,0,0} , {0,0,0} } ,\
{ {0,0,0} , {0,0,0} , {0,0,0} , {0,255,0} , {0,255,0} , {0,0,0} , {0,0,0} , {0,0,0} } ,\
{ {0,0,0} , {0,0,0} , {0,0,0} , {0,255,0} , {0,255,0} , {0,0,0} , {0,0,0} , {0,0,0} } \
};

const uint8_t arrow_left_green[8][8][3] = {\
{ {0,0,0} , {0,0,0} , {0,0,0} , {0,255,0} , {0,255,0} , {0,0,0} , {0,0,0} , {0,0,0} } ,\
{ {0,0,0} , {0,0,0} , {0,255,0} , {0,255,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} } ,\
{ {0,0,0} , {0,255,0} , {0,255,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} } ,\
{ {0,255,0} , {0,255,0} , {0,255,0} , {0,255,0} , {0,255,0} , {0,255,0} , {0,255,0} , {0,255,0} } ,\
{ {0,255,0} , {0,255,0} , {0,255,0} , {0,255,0} , {0,255,0} , {0,255,0} , {0,255,0} , {0,255,0} } ,\
{ {0,0,0} , {0,255,0} , {0,255,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} } ,\
{ {0,0,0} , {0,0,0} , {0,255,0} , {0,255,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} } ,\
{ {0,0,0} , {0,0,0} , {0,0,0} , {0,255,0} , {0,255,0} , {0,0,0} , {0,0,0} , {0,0,0} } \
};

const uint8_t arrow_right_green[8][8][3] = {\
{ {0,0,0} , {0,0,0} , {0,0,0} , {0,255,0} , {0,255,0} , {0,0,0} , {0,0,0} , {0,0,0} } ,\
{ {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,255,0} , {0,255,0} , {0,0,0} , {0,0,0} } ,\
{ {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,255,0} , {0,255,0} , {0,0,0} } ,\
{ {0,255,0} , {0,255,0} , {0,255,0} , {0,255,0} , {0,255,0} , {0,255,0} , {0,255,0} , {0,255,0} } ,\
{ {0,255,0} , {0,255,0} , {0,255,0} , {0,255,0} , {0,255,0} , {0,255,0} , {0,255,0} , {0,255,0} } ,\
{ {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,255,0} , {0,255,0} , {0,0,0} } ,\
{ {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,255,0} , {0,255,0} , {0,0,0} , {0,0,0} } ,\
{ {0,0,0} , {0,0,0} , {0,0,0} , {0,255,0} , {0,255,0} , {0,0,0} , {0,0,0} , {0,0,0} } \
};

const uint8_t arrow_down_green[8][8][3] = {\
{ {0,0,0} , {0,0,0} , {0,0,0} , {0,255,0} , {0,255,0} , {0,0,0} , {0,0,0} , {0,0,0} } ,\
{ {0,0,0} , {0,0,0} , {0,0,0} , {0,255,0} , {0,255,0} , {0,0,0} , {0,0,0} , {0,0,0} } ,\
{ {0,0,0} , {0,0,0} , {0,0,0} , {0,255,0} , {0,255,0} , {0,0,0} , {0,0,0} , {0,0,0} } ,\
{ {0,255,0} , {0,0,0} , {0,0,0} , {0,255,0} , {0,255,0} , {0,0,0} , {0,0,0} , {0,255,0} } ,\
{ {0,255,0} , {0,255,0} , {0,0,0} , {0,255,0} , {0,255,0} , {0,0,0} , {0,255,0} , {0,255,0} } ,\
{ {0,0,0} , {0,255,0} , {0,255,0} , {0,255,0} , {0,255,0} , {0,255,0} , {0,255,0} , {0,0,0} } ,\
{ {0,0,0} , {0,0,0} , {0,255,0} , {0,255,0} , {0,255,0} , {0,255,0} , {0,0,0} , {0,0,0} } ,\
{ {0,0,0} , {0,0,0} , {0,0,0} , {0,255,0} , {0,255,0} , {0,0,0} , {0,0,0} , {0,0,0} } \
};

const uint8_t arrow_up_blue[8][8][3] = {\
{ {0,0,0} , {0,0,0} , {0,0,0} , {0,0,255} , {0,0,255} , {0,0,0} , {0,0,0} , {0,0,0} } ,\
{ {0,0,0} , {0,0,0} , {0,0,255} , {0,0,255} , {0,0,255} , {0,0,255} , {0,0,0} , {0,0,0} } ,\
{ {0,0,0} , {0,0,255} , {0,0,255} , {0,0,255} , {0,0,255} , {0,0,255} , {0,0,255} , {0,0,0} } ,\
{ {0,0,255} , {0,0,255} , {0,0,0} , {0,0,255} , {0,0,255} , {0,0,0} , {0,0,255} , {0,0,255} } ,\
{ {0,0,255} , {0,0,0} , {0,0,0} , {0,0,255} , {0,0,255} , {0,0,0} , {0,0,0} , {0,0,255} } ,\
{ {0,0,0} , {0,0,0} , {0,0,0} , {0,0,255} , {0,0,255} , {0,0,0} , {0,0,0} , {0,0,0} } ,\
{ {0,0,0} , {0,0,0} , {0,0,0} , {0,0,255} , {0,0,255} , {0,0,0} , {0,0,0} , {0,0,0} } ,\
{ {0,0,0} , {0,0,0} , {0,0,0} , {0,0,255} , {0,0,255} , {0,0,0} , {0,0,0} , {0,0,0} } \
};

const uint8_t arrow_right_blue[8][8][3] = {\
{ {0,0,0} , {0,0,0} , {0,0,0} , {0,0,255} , {0,0,255} , {0,0,0} , {0,0,0} , {0,0,0} } ,\
{ {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,255} , {0,0,255} , {0,0,0} , {0,0,0} } ,\
{ {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,255} , {0,0,255} , {0,0,0} } ,\
{ {0,0,255} , {0,0,255} , {0,0,255} , {0,0,255} , {0,0,255} , {0,0,255} , {0,0,255} , {0,0,255} } ,\
{ {0,0,255} , {0,0,255} , {0,0,255} , {0,0,255} , {0,0,255} , {0,0,255} , {0,0,255} , {0,0,255} } ,\
{ {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,255} , {0,0,255} , {0,0,0} } ,\
{ {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,255} , {0,0,255} , {0,0,0} , {0,0,0} } ,\
{ {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,255} , {0,0,255} , {0,0,255} } \
};

const uint8_t arrow_down_blue[8][8][3] = {\
{ {0,0,0} , {0,0,0} , {0,0,0} , {0,0,255} , {0,0,255} , {0,0,0} , {0,0,0} , {0,0,0} } ,\
{ {0,0,0} , {0,0,0} , {0,0,0} , {0,0,255} , {0,0,255} , {0,0,0} , {0,0,0} , {0,0,0} } ,\
{ {0,0,0} , {0,0,0} , {0,0,0} , {0,0,255} , {0,0,255} , {0,0,0} , {0,0,0} , {0,0,0} } ,\
{ {0,0,255} , {0,0,0} , {0,0,0} , {0,0,255} , {0,0,255} , {0,0,0} , {0,0,0} , {0,0,255} } ,\
{ {0,0,255} , {0,0,255} , {0,0,0} , {0,0,255} , {0,0,255} , {0,0,0} , {0,0,255} , {0,0,255} } ,\
{ {0,0,0} , {0,0,255} , {0,0,255} , {0,0,255} , {0,0,255} , {0,0,255} , {0,0,255} , {0,0,0} } ,\
{ {0,0,0} , {0,0,0} , {0,0,255} , {0,0,255} , {0,0,255} , {0,0,255} , {0,0,0} , {0,0,0} } ,\
{ {0,0,0} , {0,0,0} , {0,0,0} , {0,0,255} , {0,0,255} , {0,0,0} , {0,0,0} , {0,0,0} } \
};

const uint8_t arrow_left_blue[8][8][3] = {\
{ {0,0,0} , {0,0,0} , {0,0,0} , {0,0,255} , {0,0,255} , {0,0,0} , {0,0,0} , {0,0,0} } ,\
{ {0,0,0} , {0,0,0} , {0,0,255} , {0,0,255} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} } ,\
{ {0,0,0} , {0,0,255} , {0,0,255} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} } ,\
{ {0,0,255} , {0,0,255} , {0,0,255} , {0,0,255} , {0,0,255} , {0,0,255} , {0,0,255} , {0,0,255} } ,\
{ {0,0,255} , {0,0,255} , {0,0,255} , {0,0,255} , {0,0,255} , {0,0,255} , {0,0,255} , {0,0,255} } ,\
{ {0,0,0} , {0,0,255} , {0,0,255} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} } ,\
{ {0,0,0} , {0,0,0} , {0,0,255} , {0,0,255} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} } ,\
{ {0,0,0} , {0,0,0} , {0,0,0} , {0,0,255} , {0,0,255} , {0,0,0} , {0,0,0} , {0,0,0} } \
};

const uint8_t flag_japan[8][8][3] = {\
{ {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} },\
{ {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} },\
{ {255,255,255} , {255,255,255} , {255,255,255} , {255,0,0} , {255,0,0} , {255,255,255} , {255,255,255} , {255,255,255} },\
{ {255,255,255} , {255,255,255} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,255,255} , {255,255,255} },\
{ {255,255,255} , {255,255,255} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,255,255} , {255,255,255} },\
{ {255,255,255} , {255,255,255} , {255,255,255} , {255,0,0} , {255,0,0} , {255,255,255} , {255,255,255} , {255,255,255} },\
{ {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} },\
{ {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} }\
};

const uint8_t flag_spain[8][8][3] = {\
{ {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} } ,\
{ {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} } ,\
{ {255,255,0} , {255,255,0} , {255,255,0} , {255,255,0} , {255,255,0} , {255,255,0} , {255,255,0} , {255,255,0} } ,\
{ {255,255,0} , {255,255,0} , {165,42,42} , {165,42,42} , {255,255,0} , {255,255,0} , {255,255,0} , {255,255,0} } ,\
{ {255,255,0} , {255,255,0} , {165,42,42} , {165,42,42} , {255,255,0} , {255,255,0} , {255,255,0} , {255,255,0} } ,\
{ {255,255,0} , {255,255,0} , {255,255,0} , {255,255,0} , {255,255,0} , {255,255,0} , {255,255,0} , {255,255,0} } ,\
{ {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} } ,\
{ {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} } \
};

const uint8_t flag_china[8][8][3] = {\
{ {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} } ,\
{ {255,0,0} , {255,0,0} , {255,0,0} , {255,255,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} } ,\
{ {255,0,0} , {255,255,0} , {255,255,0} , {255,255,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} } ,\
{ {255,0,0} , {255,255,0} , {255,255,0} , {255,255,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} } ,\
{ {255,0,0} , {255,0,0} , {255,0,0} , {255,255,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} } ,\
{ {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} } ,\
{ {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} } ,\
{ {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} } \
};

const uint8_t flag_greatBritain[8][8][3] = {\
{ {255,255,255} , {0,0,255} , {0,0,255} , {255,0,0} , {255,0,0} , {0,0,255} , {0,0,255} , {255,255,255} } ,\
{ {0,0,255} , {255,255,255} , {0,0,255} , {255,0,0} , {255,0,0} , {0,0,255} , {255,255,255} , {0,0,255} } ,\
{ {0,0,255} , {0,0,255} , {255,255,255} , {255,0,0} , {255,0,0} , {255,255,255} , {0,0,255} , {0,0,255} } ,\
{ {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} } ,\
{ {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} } ,\
{ {0,0,255} , {0,0,255} , {255,255,255} , {255,0,0} , {255,0,0} , {255,255,255} , {0,0,255} , {0,0,255} } ,\
{ {0,0,255} , {255,255,255} , {0,0,255} , {255,0,0} , {255,0,0} , {0,0,255} , {255,255,255} , {0,0,255} } ,\
{ {255,255,255} , {0,0,255} , {0,0,255} , {255,0,0} , {255,0,0} , {0,0,255} , {0,0,255} , {255,255,255} } \
};

const uint8_t flag_germany[8][8][3] = {\
{ {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} } ,\
{ {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} } ,\
{ {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} } ,\
{ {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} } ,\
{ {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} } ,\
{ {255,255,0} , {255,255,0} , {255,255,0} , {255,255,0} , {255,255,0} , {255,255,0} , {255,255,0} , {255,255,0} } ,\
{ {255,255,0} , {255,255,0} , {255,255,0} , {255,255,0} , {255,255,0} , {255,255,0} , {255,255,0} , {255,255,0} } ,\
{ {255,255,0} , {255,255,0} , {255,255,0} , {255,255,0} , {255,255,0} , {255,255,0} , {255,255,0} , {255,255,0} } \
};

const uint8_t flag_france[8][8][3] = {\
{ {0,0,255} , {0,0,255} , {0,0,255} , {255,255,255} , {255,255,255} , {255,0,0} , {255,0,0} , {255,0,0} } ,\
{ {0,0,255} , {0,0,255} , {0,0,255} , {255,255,255} , {255,255,255} , {255,0,0} , {255,0,0} , {255,0,0} } ,\
{ {0,0,255} , {0,0,255} , {0,0,255} , {255,255,255} , {255,255,255} , {255,0,0} , {255,0,0} , {255,0,0} } ,\
{ {0,0,255} , {0,0,255} , {0,0,255} , {255,255,255} , {255,255,255} , {255,0,0} , {255,0,0} , {255,0,0} } ,\
{ {0,0,255} , {0,0,255} , {0,0,255} , {255,255,255} , {255,255,255} , {255,0,0} , {255,0,0} , {255,0,0} } ,\
{ {0,0,255} , {0,0,255} , {0,0,255} , {255,255,255} , {255,255,255} , {255,0,0} , {255,0,0} , {255,0,0} } ,\
{ {0,0,255} , {0,0,255} , {0,0,255} , {255,255,255} , {255,255,255} , {255,0,0} , {255,0,0} , {255,0,0} } ,\
{ {0,0,255} , {0,0,255} , {0,0,255} , {255,255,255} , {255,255,255} , {255,0,0} , {255,0,0} , {255,0,0} } \
};

const uint8_t flag_belgium[8][8][3] = {\
{ {0,0,0} , {0,0,0} , {0,0,0} , {255,255,0} , {255,255,0} , {255,0,0} , {255,0,0} , {255,0,0} } ,\
{ {0,0,0} , {0,0,0} , {0,0,0} , {255,255,0} , {255,255,0} , {255,0,0} , {255,0,0} , {255,0,0} } ,\
{ {0,0,0} , {0,0,0} , {0,0,0} , {255,255,0} , {255,255,0} , {255,0,0} , {255,0,0} , {255,0,0} } ,\
{ {0,0,0} , {0,0,0} , {0,0,0} , {255,255,0} , {255,255,0} , {255,0,0} , {255,0,0} , {255,0,0} } ,\
{ {0,0,0} , {0,0,0} , {0,0,0} , {255,255,0} , {255,255,0} , {255,0,0} , {255,0,0} , {255,0,0} } ,\
{ {0,0,0} , {0,0,0} , {0,0,0} , {255,255,0} , {255,255,0} , {255,0,0} , {255,0,0} , {255,0,0} } ,\
{ {0,0,0} , {0,0,0} , {0,0,0} , {255,255,0} , {255,255,0} , {255,0,0} , {255,0,0} , {255,0,0} } ,\
{ {0,0,0} , {0,0,0} , {0,0,0} , {255,255,0} , {255,255,0} , {255,0,0} , {255,0,0} , {255,0,0} } \
};

const uint8_t flag_singapore[8][8][3] = {\
{ {255,0,0} , {255,0,0} , {255,255,255} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} } ,\
{ {255,0,0} , {255,255,255} , {255,0,0} , {255,255,255} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} } ,\
{ {255,0,0} , {255,255,255} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} } ,\
{ {255,0,0} , {255,0,0} , {255,255,255} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} } ,\
{ {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} } ,\
{ {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} } ,\
{ {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} } ,\
{ {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} } \
};

const uint8_t flag_hongKong[8][8][3] = {\
{ {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} } ,\
{ {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} } ,\
{ {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,255,255} , {255,0,0} , {255,0,0} , {255,0,0} } ,\
{ {255,0,0} , {255,0,0} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,0,0} , {255,0,0} } ,\
{ {255,0,0} , {255,0,0} , {255,0,0} , {255,255,255} , {255,255,255} , {255,0,0} , {255,0,0} , {255,0,0} } ,\
{ {255,0,0} , {255,0,0} , {255,255,255} , {255,0,0} , {255,255,255} , {255,0,0} , {255,0,0} , {255,0,0} } ,\
{ {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} } ,\
{ {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} } \
};

const uint8_t flag_rainbow[8][8][3] = {\
{ {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} } ,\
{ {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} } ,\
{ {255,165,0} , {255,165,0} , {255,165,0} , {255,165,0} , {255,165,0} , {255,165,0} , {255,165,0} , {255,165,0} } ,\
{ {255,255,0} , {255,255,0} , {255,255,0} , {255,255,0} , {255,255,0} , {255,255,0} , {255,255,0} , {255,255,0} } ,\
{ {0,255,0} , {0,255,0} , {0,255,0} , {0,255,0} , {0,255,0} , {0,255,0} , {0,255,0} , {0,255,0} } ,\
{ {0,0,255} , {0,0,255} , {0,0,255} , {0,0,255} , {0,0,255} , {0,0,255} , {0,0,255} , {0,0,255} } ,\
{ {128,0,128} , {128,0,128} , {128,0,128} , {128,0,128} , {128,0,128} , {128,0,128} , {128,0,128} , {128,0,128} } ,\
{ {128,0,128} , {128,0,128} , {128,0,128} , {128,0,128} , {128,0,128} , {128,0,128} , {128,0,128} , {128,0,128} } \
};

const uint8_t flag_white[8][8][3] = {\
{ {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} } ,\
{ {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} } ,\
{ {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} } ,\
{ {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} } ,\
{ {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} } ,\
{ {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} } ,\
{ {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} } ,\
{ {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} } \
};

const uint8_t flag_sweden[8][8][3] = {\
{ {0,0,255} , {0,0,255} , {0,0,255} , {255,255,0} , {255,255,0} , {0,0,255} , {0,0,255} , {0,0,255} } ,\
{ {0,0,255} , {0,0,255} , {0,0,255} , {255,255,0} , {255,255,0} , {0,0,255} , {0,0,255} , {0,0,255} } ,\
{ {0,0,255} , {0,0,255} , {0,0,255} , {255,255,0} , {255,255,0} , {0,0,255} , {0,0,255} , {0,0,255} } ,\
{ {255,255,0} , {255,255,0} , {255,255,0} , {255,255,0} , {255,255,0} , {255,255,0} , {255,255,0} , {255,255,0} } ,\
{ {255,255,0} , {255,255,0} , {255,255,0} , {255,255,0} , {255,255,0} , {255,255,0} , {255,255,0} , {255,255,0} } ,\
{ {0,0,255} , {0,0,255} , {0,0,255} , {255,255,0} , {255,255,0} , {0,0,255} , {0,0,255} , {0,0,255} } ,\
{ {0,0,255} , {0,0,255} , {0,0,255} , {255,255,0} , {255,255,0} , {0,0,255} , {0,0,255} , {0,0,255} } ,\
{ {0,0,255} , {0,0,255} , {0,0,255} , {255,255,0} , {255,255,0} , {0,0,255} , {0,0,255} , {0,0,255} } \
};

const uint8_t colorTest[8][8][3] = {\
{ {255,0,0} , {255,0,0} , {0,255,0} , {0,255,0} , {0,0,255} , {0,0,255} , {255,165,0} , {255,165,0} } ,\
{ {255,0,0} , {255,0,0} , {0,255,0} , {0,255,0} , {0,0,255} , {0,0,255} , {255,165,0} , {255,165,0} } ,\
{ {128,0,128} , {128,0,128} , {255,0,255} , {255,0,255} , {0,255,255} , {0,255,255} , {255,255,0} , {255,255,0} } ,\
{ {128,0,128} , {128,0,128} , {255,0,255} , {255,0,255} , {0,255,255} , {0,255,255} , {255,255,0} , {255,255,0} } ,\
{ {144,238,144} , {144,238,144} , {165,42,42} , {165,42,42} , {255,105,180} , {255,105,180} , {0,100,0} , {0,100,0} } ,\
{ {144,238,144} , {144,238,144} , {165,42,42} , {165,42,42} , {255,105,180} , {255,105,180} , {0,100,0} , {0,100,0} } ,\
{ {173,216,230} , {173,216,230} , {0,0,128} , {0,0,128} , {255,204,203} , {255,204,203} , {139,0,0} , {139,0,0} } ,\
{ {173,216,230} , {173,216,230} , {0,0,128} , {0,0,128} , {255,204,203} , {255,204,203} , {139,0,0} , {139,0,0} } \
};

const uint8_t scaleTest1[8][8][3] = {\
{ {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {0,255,0} , {0,255,0} , {0,255,0} , {0,255,0} } ,\
{ {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {0,255,0} , {0,255,0} , {0,255,0} , {0,255,0} } ,\
{ {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {0,255,0} , {0,255,0} , {0,255,0} , {0,255,0} } ,\
{ {255,0,0} , {255,0,0} , {255,0,0} , {255,0,0} , {0,255,0} , {0,255,0} , {0,255,0} , {0,255,0} } ,\
{ {0,0,255} , {0,0,255} , {0,0,255} , {0,0,255} , {255,255,0} , {255,255,0} , {255,255,0} , {255,255,0} } ,\
{ {0,0,255} , {0,0,255} , {0,0,255} , {0,0,255} , {255,255,0} , {255,255,0} , {255,255,0} , {255,255,0} } ,\
{ {0,0,255} , {0,0,255} , {0,0,255} , {0,0,255} , {255,255,0} , {255,255,0} , {255,255,0} , {255,255,0} } ,\
{ {0,0,255} , {0,0,255} , {0,0,255} , {0,0,255} , {255,255,0} , {255,255,0} , {255,255,0} , {255,255,0} } \
};

const uint8_t scaleTest2[8][8][3] = {\
{ {255,0,0} , {0,255,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} } ,\
{ {0,0,255} , {255,255,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} } ,\
{ {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} } ,\
{ {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} } ,\
{ {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} } ,\
{ {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} } ,\
{ {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} } ,\
{ {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} } \
};

const uint8_t half_scale_flag_sweden[8][8][3] = {\
{ {0,0,255} , {255,255,255} , {255,255,255} , {0,0,255} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} } ,\
{ {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} } ,\
{ {255,255,255} , {255,255,255} , {255,255,255} , {255,255,255} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} } ,\
{ {0,0,255} , {255,255,255} , {255,255,255} , {0,0,255} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} } ,\
{ {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} } ,\
{ {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} } ,\
{ {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} } ,\
{ {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} } ,\
};

const uint8_t compass_needle[8][8][3] = {\
{ {0,0,0} , {0,0,0} , {0,0,0} , {255,0,0} , {255,0,0} , {0,0,0} , {0,0,0} , {0,0,0} } ,\
{ {0,0,0} , {0,0,0} , {0,0,0} , {255,0,0} , {255,0,0} , {0,0,0} , {0,0,0} , {0,0,0} } ,\
{ {0,0,0} , {0,0,0} , {0,0,0} , {255,0,0} , {255,0,0} , {0,0,0} , {0,0,0} , {0,0,0} } ,\
{ {0,0,0} , {0,0,0} , {0,0,0} , {255,0,0} , {255,0,0} , {0,0,0} , {0,0,0} , {0,0,0} } ,\
{ {0,0,0} , {0,0,0} , {0,0,0} , {0,0,255} , {0,0,255} , {0,0,0} , {0,0,0} , {0,0,0} } ,\
{ {0,0,0} , {0,0,0} , {0,0,0} , {0,0,255} , {0,0,255} , {0,0,0} , {0,0,0} , {0,0,0} } ,\
{ {0,0,0} , {0,0,0} , {0,0,0} , {0,0,255} , {0,0,255} , {0,0,0} , {0,0,0} , {0,0,0} } ,\
{ {0,0,0} , {0,0,0} , {0,0,0} , {0,0,255} , {0,0,255} , {0,0,0} , {0,0,0} , {0,0,0} } \
};

const uint8_t null_flag[8][8][3] = {\
{ {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} } ,\
{ {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} } ,\
{ {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} } ,\
{ {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} } ,\
{ {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} } ,\
{ {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} } ,\
{ {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} } ,\
{ {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} , {0,0,0} } \
};

#endif