#include "mbed.h"
#include "neopixel.h"
#include "neopixel.c"
#include "neopixel_alphabet.h"
#include "neopixel_array.h"
#include "neopixel_digits.h"
#include "neopixel_manip.h"
#include "accmag.h"

/* Pin defines */
#define SDA P0_2
#define SCL P0_0
#define DOUT P0_3

/* Global variables */
neopixel_strip_t strip;
I2C i2c(SDA,SCL);
Serial debug(USBTX,USBRX);
DigitalOut status(LED1);

double thetaCalc(int nx, int ny)
{
    double M_PI = 3.14159265358979323846;
    double theta;
    if (nx >= 0 && ny >= 0)
    {
        theta = 2*M_PI - atan((double)(nx)/(double)(ny));
    }
    else if (nx < 0 && ny >= 0)
    {
        theta = atan((double)(abs(nx))/(double)(abs(ny)));
    }
    else if (nx < 0 && ny < 0)
    {
        theta = M_PI - (M_PI/2 - atan((double)(ny) / (double)(nx)));
    }
    else
    {
        theta = M_PI - (atan((double)(nx)/(double)(ny)));
    }
    return theta;
}

int main() {
    char aregisters[6] = {OUT_X_L_A,OUT_X_H_A,OUT_Y_L_A,OUT_Y_H_A,OUT_Z_L_A,OUT_Z_H_A};
    char mregisters[6] = {OUT_X_H_M,OUT_X_L_M,OUT_Y_H_M,OUT_Y_L_M,OUT_Z_H_M,OUT_Z_L_M};
    uint8_t arr1[8][8][3];
    uint8_t arr2[16][8][3];
    double theta = 0;
    int16_t accx, accy, accz, magx, magy, magz;
    
    neopixel_init(&strip,DOUT,128);
    
    startAcc(i2c);
    
    startMag(i2c);
    
    while(1) {
        readAcc(i2c,aregisters,&accx,&accy,&accz);
        readMag(i2c,mregisters,&magx,&magy,&magz);
        theta = thetaCalc(magx,magz);
        rotate_ccw(compass_needle,arr1,3.5,3.5,theta);
        if (accz < 0)
        {
            rotate_ccw(compass_needle,arr1,3.5,3.5,theta);
            catArr(arr1,null_flag,arr2);
        }
        else
        {
            rotate_cw(compass_needle,arr1,3.5,3.5,theta);
            catArr(null_flag,arr1,arr2);
        }
        showArray2(&strip,arr2,0.1);
    }
}
