#ifndef NEOPIXEL_MANIP_H
#define NEOPIXEL_MANIP_H
#include <math.h>
#include <stdarg.h>

#define SIZE 64
#define SIDE 8

typedef enum _cCode_
    {
        wh,bl,re,gr,bu,ye,cy,ma
    } cCode;

void clearArr(uint8_t arr[SIDE][SIDE][3])
{
    for (int i=0; i<SIDE; i++)
    {
        for (int j=0; j<SIDE; j++)
        {
            for (int k=0; k<3; k++)
            {
                arr[i][j][k] = 0;
            }
        }
    }
}

void clearFlatArr(uint8_t arr[SIDE*SIDE][3])
{
    for (int n=0; n<SIDE*SIDE; n++)
    {
        for (int m=0; m<3; m++)
        {
            arr[n][m] = 0;
        }
    }
}

void copyArr(const uint8_t arr[SIDE][SIDE][3], uint8_t newArr[SIDE][SIDE][3])
{
    for (int i=0; i<SIDE; i++)
    {
        for (int j=0; j<SIDE; j++)
        {
            for (int k=0; k<3; k++)
            {
                newArr[i][j][k] = arr[i][j][k];
            }
        }
    }
}

void flatten(const uint8_t arr[SIDE][SIDE][3], uint8_t newArr[SIZE][3])
{
    for (int i=0; i<SIDE; i++)
    {
        for (int j=0; j<SIDE; j++)
        {
            for (int k=0; k<3; k++)
            {
                newArr[i+SIDE*j][k] = arr[i][j][k];
            }
        }
    }
}

void unflatten(const uint8_t arr[SIZE][3], uint8_t newArr[SIDE][SIDE][3])
{
    for (int n=0; n<SIZE; n++)
    {
        for (int m=0; m<3; m++)
        {
            newArr[n%SIDE][n/SIDE][m] = arr[n][m];
        }
    }
}

void rotate_ccw(const uint8_t arr[SIDE][SIDE][3], uint8_t newArr[SIDE][SIDE][3], float px, float py, double rad)
{
    double X, Y, oldX, oldY;
    int il,ih,jl,jh;
    
    for (int i=0; i<SIDE; i++)
    {
        for (int j=0; j<SIDE; j++)
        {
            int sum[3] = {0,0,0};
            int count = 0;
            X = i - px;
            Y = j - py;
            oldX = X*cos(rad) - Y*sin(rad);
            oldY = X*sin(rad) + Y*cos(rad);
            il = floor(oldX+ceil(px));
            ih = ceil(oldX+floor(px));
            jl = floor(oldY+ceil(py));
            jh = ceil(oldY+floor(py));
            if (il < SIDE && il >=0 && jl < SIDE && jl >=0)
            {
                for (int k=0; k<3; k++)
                {
                    sum[k] += arr[il][jl][k];
                }
                count ++;
            }
            if (ih < SIDE && ih >= 0 && jl < SIDE && jl >= 0)
            {
                for (int k=0; k<3; k++)
                {
                    sum[k] += arr[ih][jl][k];
                }
                count ++;
            }
            if (il < SIDE && il >=0 && jh < SIDE && jh >=0)
            {
                for (int k=0; k<3; k++)
                {
                    sum[k] += arr[il][jh][k];
                }
                count ++;
            }
            if (ih < SIDE && ih >= 0 && jh < SIDE && jh >= 0)
            {
                for (int k=0; k<3; k++)
                {
                    sum[k] += arr[ih][jh][k];
                }
                count ++;
            }
            for (int k=0; k<3; k++)
            {
                newArr[i][j][k] = sum[k] / count;
            }
        }
    }
}

void rotate_cw(const uint8_t arr[SIDE][SIDE][3], uint8_t newArr[SIDE][SIDE][3], float px, float py, double rad)
{
    double X, Y, oldX, oldY;
    int il,ih,jl,jh;
    
    for (int i=0; i<SIDE; i++)
    {
        for (int j=0; j<SIDE; j++)
        {
            int sum[3] = {0,0,0};
            int count = 0;
            X = i - px;
            Y = j - py;
            oldX = X*cos(rad) + Y*sin(rad);
            oldY = -X*sin(rad) + Y*cos(rad);
            il = floor(oldX+ceil(px));
            ih = ceil(oldX+floor(px));
            jl = floor(oldY+ceil(py));
            jh = ceil(oldY+floor(py));
            if (il < SIDE && il >=0 && jl < SIDE && jl >=0)
            {
                for (int k=0; k<3; k++)
                {
                    sum[k] += arr[il][jl][k];
                }
                count ++;
            }
            if (ih < SIDE && ih >= 0 && jl < SIDE && jl >= 0)
            {
                for (int k=0; k<3; k++)
                {
                    sum[k] += arr[ih][jl][k];
                }
                count ++;
            }
            if (il < SIDE && il >=0 && jh < SIDE && jh >=0)
            {
                for (int k=0; k<3; k++)
                {
                    sum[k] += arr[il][jh][k];
                }
                count ++;
            }
            if (ih < SIDE && ih >= 0 && jh < SIDE && jh >= 0)
            {
                for (int k=0; k<3; k++)
                {
                    sum[k] += arr[ih][jh][k];
                }
                count ++;
            }
            for (int k=0; k<3; k++)
            {
                newArr[i][j][k] = sum[k] / count;
            }
        }
    }
}

void rotate_ccw(const uint8_t arr[SIDE][SIDE][3], uint8_t newArr[SIDE][SIDE][3], float px, float py, double rad, cCode colorCode)
{
    double X, Y, oldX, oldY;
    int il,ih,jl,jh;
    uint8_t colors[3] = {0,0,0};
    switch (colorCode)
    {
        case wh:
        colors[0] = 255;
        colors[1] = 255;
        colors[2] = 255;
        break;
        case bl:
        colors[0] = 0;
        colors[1] = 0;
        colors[2] = 0;
        break;
        case re:
        colors[0] = 255;
        colors[1] = 0;
        colors[2] = 0;
        break;
        case gr:
        colors[0] = 0;
        colors[1] = 255;
        colors[2] = 0;
        break;
        case bu:
        colors[0] = 0;
        colors[1] = 0;
        colors[2] = 255;
        break;
        case ye:
        colors[0] = 255;
        colors[1] = 255;
        colors[2] = 0;
        break;
        case cy:
        colors[0] = 0;
        colors[1] = 255;
        colors[2] = 255;
        break;
        case ma:
        colors[0] = 255;
        colors[1] = 0;
        colors[2] = 255;
        break;
        default:
        colors[0] = 255;
        colors[1] = 255;
        colors[2] = 255;
        break;
    }
    for (int i=0; i<SIDE; i++)
    {
        for (int j=0; j<SIDE; j++)
        {
            int sum[3] = {0,0,0};
            int count = 0;
            X = i - px;
            Y = j - py;
            oldX = X*cos(rad) - Y*sin(rad);
            oldY = X*sin(rad) + Y*cos(rad);
            il = floor(oldX+ceil(px));
            ih = ceil(oldX+floor(px));
            jl = floor(oldY+ceil(py));
            jh = ceil(oldY+floor(py));
            if (il < SIDE && il >=0 && jl < SIDE && jl >=0)
            {
                for (int k=0; k<3; k++)
                {
                    sum[k] += arr[il][jl][k];
                }
                count ++;
            }
            else
            {
                for (int k=0; k<3; k++)
                {
                    sum[k] = colors[k];
                }
                count ++;
            }
            if (ih < SIDE && ih >= 0 && jl < SIDE && jl >= 0)
            {
                for (int k=0; k<3; k++)
                {
                    sum[k] += arr[ih][jl][k];
                }
                count ++;
            }
            else
            {
                for (int k=0; k<3; k++)
                {
                    sum[k] += colors[k];
                }
                count ++;
            }
            if (il < SIDE && il >=0 && jh < SIDE && jh >=0)
            {
                for (int k=0; k<3; k++)
                {
                    sum[k] += arr[il][jh][k];
                }
                count ++;
            }
            else
            {
                for (int k=0; k<3; k++)
                {
                    sum[k] += colors[k];
                }
                count ++;
            }
            if (ih < SIDE && ih >= 0 && jh < SIDE && jh >= 0)
            {
                for (int k=0; k<3; k++)
                {
                    sum[k] += arr[ih][jh][k];
                }
                count ++;
            }
            else
            {
                for (int k=0; k<3; k++)
                {
                    sum[k] += colors[k];
                }
                count ++;
            }
            for (int k=0; k<3; k++)
            {
                newArr[i][j][k] = sum[k] / count;
            }
        }
    }
}

void rotate_cw(const uint8_t arr[SIDE][SIDE][3], uint8_t newArr[SIDE][SIDE][3], float px, float py, double rad, cCode colorCode)
{
    double X, Y, oldX, oldY;
    int il,ih,jl,jh;
    uint8_t colors[3] = {0,0,0};
    switch (colorCode)
    {
        case wh:
        colors[0] = 255;
        colors[1] = 255;
        colors[2] = 255;
        break;
        case bl:
        colors[0] = 0;
        colors[1] = 0;
        colors[2] = 0;
        break;
        case re:
        colors[0] = 255;
        colors[1] = 0;
        colors[2] = 0;
        break;
        case gr:
        colors[0] = 0;
        colors[1] = 255;
        colors[2] = 0;
        break;
        case bu:
        colors[0] = 0;
        colors[1] = 0;
        colors[2] = 255;
        break;
        case ye:
        colors[0] = 255;
        colors[1] = 255;
        colors[2] = 0;
        break;
        case cy:
        colors[0] = 0;
        colors[1] = 255;
        colors[2] = 255;
        break;
        case ma:
        colors[0] = 255;
        colors[1] = 0;
        colors[2] = 255;
        break;
        default:
        colors[0] = 255;
        colors[1] = 255;
        colors[2] = 255;
        break;
    }
    for (int i=0; i<SIDE; i++)
    {
        for (int j=0; j<SIDE; j++)
        {
            int sum[3] = {0,0,0};
            int count = 0;
            X = i - px;
            Y = j - py;
            oldX = X*cos(rad) + Y*sin(rad);
            oldY = -X*sin(rad) + Y*cos(rad);
            il = floor(oldX+ceil(px));
            ih = ceil(oldX+floor(px));
            jl = floor(oldY+ceil(py));
            jh = ceil(oldY+floor(py));
            if (il < SIDE && il >=0 && jl < SIDE && jl >=0)
            {
                for (int k=0; k<3; k++)
                {
                    sum[k] += arr[il][jl][k];
                }
                count ++;
            }
            else
            {
                for (int k=0; k<3; k++)
                {
                    sum[k] = colors[k];
                }
                count ++;
            }
            if (ih < SIDE && ih >= 0 && jl < SIDE && jl >= 0)
            {
                for (int k=0; k<3; k++)
                {
                    sum[k] += arr[ih][jl][k];
                }
                count ++;
            }
            else
            {
                for (int k=0; k<3; k++)
                {
                    sum[k] = colors[k];
                }
                count ++;
            }
            if (il < SIDE && il >=0 && jh < SIDE && jh >=0)
            {
                for (int k=0; k<3; k++)
                {
                    sum[k] += arr[il][jh][k];
                }
                count ++;
            }
            else
            {
                for (int k=0; k<3; k++)
                {
                    sum[k] = colors[k];
                }
                count ++;
            }
            if (ih < SIDE && ih >= 0 && jh < SIDE && jh >= 0)
            {
                for (int k=0; k<3; k++)
                {
                    sum[k] += arr[ih][jh][k];
                }
                count ++;
            }
            else
            {
                for (int k=0; k<3; k++)
                {
                    sum[k] = colors[k];
                }
                count ++;
            }
            for (int k=0; k<3; k++)
            {
                newArr[i][j][k] = sum[k] / count;
            }
        }
    }
}

void translate_v(const uint8_t arr[SIDE][SIDE][3], uint8_t newArr[SIDE][SIDE][3], int shift)
{
    int newi;
    for (int i=0; i<SIDE; i++)
    {
        for (int j=0; j<SIDE; j++)
        {
            for (int k=0; k<3; k++)
            {
                newArr[i][j][k] = 0;
            }
        }
    }
    for (int i=0; i<SIDE; i++)
    {
        for (int j=0; j<SIDE; j++)
        {
            for (int k=0; k<3; k++)
            {
                newi = i - shift;
                if (newi >= 0 && newi < SIDE)
                {
                    newArr[newi][j][k] = arr[i][j][k];
                }
            }
        }
    }
}

void translate_h(const uint8_t arr[SIDE][SIDE][3], uint8_t newArr[SIDE][SIDE][3], int shift)
{
    int newj;
    for (int i=0; i<SIDE; i++)
    {
        for (int j=0; j<SIDE; j++)
        {
            for (int k=0; k<3; k++)
            {
                newArr[i][j][k] = 0;
            }
        }
    }
    for (int i=0; i<SIDE; i++)
    {
        for (int j=0; j<SIDE; j++)
        {
            for (int k=0; k<3; k++)
            {
                newj = j - shift;
                if (newj >= 0 && newj < SIDE)
                {
                    newArr[i][newj][k] = arr[i][j][k];
                }
            }
        }
    }
}

void translate_v(const uint8_t arr[SIDE][SIDE][3], uint8_t newArr[SIDE][SIDE][3], int shift, cCode colorCode)
{
    int newi;
    uint8_t colors[3] = {0,0,0};
    switch (colorCode)
    {
        case wh:
        colors[0] = 255;
        colors[1] = 255;
        colors[2] = 255;
        break;
        case bl:
        colors[0] = 0;
        colors[1] = 0;
        colors[2] = 0;
        break;
        case re:
        colors[0] = 255;
        colors[1] = 0;
        colors[2] = 0;
        break;
        case gr:
        colors[0] = 0;
        colors[1] = 255;
        colors[2] = 0;
        break;
        case bu:
        colors[0] = 0;
        colors[1] = 0;
        colors[2] = 255;
        break;
        case ye:
        colors[0] = 255;
        colors[1] = 255;
        colors[2] = 0;
        break;
        case cy:
        colors[0] = 0;
        colors[1] = 255;
        colors[2] = 255;
        break;
        case ma:
        colors[0] = 255;
        colors[1] = 0;
        colors[2] = 255;
        break;
        default:
        colors[0] = 255;
        colors[1] = 255;
        colors[2] = 255;
        break;
    }
    for (int i=0; i<SIDE; i++)
    {
        for (int j=0; j<SIDE; j++)
        {
            for (int k=0; k<3; k++)
            {
                newArr[i][j][k] = colors[k];
            }
        }
    }
    for (int i=0; i<SIDE; i++)
    {
        for (int j=0; j<SIDE; j++)
        {
            for (int k=0; k<3; k++)
            {
                newi = i - shift;
                if (newi >= 0 && newi < SIDE)
                {
                    newArr[newi][j][k] = arr[i][j][k];
                }
            }
        }
    }
}

void translate_h(const uint8_t arr[SIDE][SIDE][3], uint8_t newArr[SIDE][SIDE][3], int shift, cCode colorCode)
{
    int newj;
    uint8_t colors[3] = {0,0,0};
    switch (colorCode)
    {
        case wh:
        colors[0] = 255;
        colors[1] = 255;
        colors[2] = 255;
        break;
        case bl:
        colors[0] = 0;
        colors[1] = 0;
        colors[2] = 0;
        break;
        case re:
        colors[0] = 255;
        colors[1] = 0;
        colors[2] = 0;
        break;
        case gr:
        colors[0] = 0;
        colors[1] = 255;
        colors[2] = 0;
        break;
        case bu:
        colors[0] = 0;
        colors[1] = 0;
        colors[2] = 255;
        break;
        case ye:
        colors[0] = 255;
        colors[1] = 255;
        colors[2] = 0;
        break;
        case cy:
        colors[0] = 0;
        colors[1] = 255;
        colors[2] = 255;
        break;
        case ma:
        colors[0] = 255;
        colors[1] = 0;
        colors[2] = 255;
        break;
        default:
        colors[0] = 255;
        colors[1] = 255;
        colors[2] = 255;
        break;
    }
    for (int i=0; i<SIDE; i++)
    {
        for (int j=0; j<SIDE; j++)
        {
            for (int k=0; k<3; k++)
            {
                newArr[i][j][k] = colors[k];
            }
        }
    }
    for (int i=0; i<SIDE; i++)
    {
        for (int j=0; j<SIDE; j++)
        {
            for (int k=0; k<3; k++)
            {
                newj = j - shift;
                if (newj >= 0 && newj < SIDE)
                {
                    newArr[i][newj][k] = arr[i][j][k];
                }
            }
        }
    }
}
void wrap_v(const uint8_t arr[SIDE][SIDE][3], uint8_t newArr[SIDE][SIDE][3], unsigned int shift)
{
    for (int i=0; i<SIDE; i++)
    {
        for (int j=0; j<SIDE; j++)
        {
            for (int k=0; k<3; k++)
            {
                newArr[(i-shift)%SIDE][j][k] = arr[i][j][k];
            }
        }
    }
}

void wrap_h(const uint8_t arr[SIDE][SIDE][3], uint8_t newArr[SIDE][SIDE][3], unsigned int shift)
{
    for (int i=0; i<SIDE; i++)
    {
        for (int j=0; j<SIDE; j++)
        {
            for (int k=0; k<3; k++)
            {
                newArr[i][j][k] = arr[i][(j+shift)%SIDE][k];
            }
        }
    }
}

void catArrOld(const uint8_t arr1[SIDE][SIDE][3], const uint8_t arr2[SIDE][SIDE][3], uint8_t outArr [SIDE][2*SIDE][3])
{
    for (int i=SIDE-1; i>=0; i--)
    {
        for (int j=SIDE-1; j>=0; j--)
        {
            for (int k=0; k<3; k++)
            {
                outArr[i][j][k] = arr1[i][j][k];
            }
        }
        for (int j=SIDE*2-1; j>=SIDE; j--)
        {
            for (int k=0; k<3; k++)
            {
                outArr[i][j][k] = arr2[i][j-SIDE][k];
            }
        }
    }
}

void catArr(const uint8_t arr1[SIDE][SIDE][3], const uint8_t arr2[SIDE][SIDE][3], uint8_t outArr [SIDE*2][SIDE][3])
{
    for (int i=0; i<16; i++)
    {
        for (int j=0; j<8; j++)
        {
            if (i >= 8)
            {
                for (int k=0; k<3; k++)
                {
                    outArr[i][j][k] = arr2[i-8][j][k];
                }
            }
            else
            {
                for (int k=0; k<3; k++)
                {
                    outArr[i][j][k] = arr1[i][j][k];
                }
            }
        }
    }
}

void splitArrOld(const uint8_t arr[SIDE][SIDE*2][3], uint8_t narr1[SIDE][SIDE][3], uint8_t narr2[SIDE][SIDE][3])
{
    for (int i=0; i<SIDE; i++)
    {
        for (int j=0; j<SIDE; j++)
        {
            for (int k=0; k<3; k++)
            {
                narr1[i][j][k] = arr[i][j][k];
            }
        }
    }
    for (int i=0; i<SIDE; i++)
    {
        for (int j=0; j<SIDE; j++)
        {
            for (int k=0; k<3; k++)
            {
                narr2[i][j][k] = arr[i][j+8][k];
            }
        }
    }
}

void invert(const uint8_t arr[SIDE][SIDE][3], uint8_t newArr[SIDE][SIDE][3])
{
    for (int i=0; i<SIDE; i++)
    {
        for (int j=0; j<SIDE; j++)
        {
            for (int k=0; k<SIDE; k++)
            {
                newArr[i][j][k] = 255 - arr[i][j][k];
            }
        }
    }
}

void mirror_v(const uint8_t arr[SIDE][SIDE][3], uint8_t newArr[SIDE][SIDE][3])
{
    for (int i=0; i<SIDE; i++)
    {
        for (int j=0; j<SIDE; j++)
        {
            for (int k=0; k<SIDE; k++)
            {
                newArr[i][j][k] = arr[SIDE - i - 1][j][k];
            }
        }
    }
}

void mirror_h(const uint8_t arr[SIDE][SIDE][3], uint8_t newArr[SIDE][SIDE][3])
{
    for (int i=0; i<SIDE; i++)
    {
        for (int j=0; j<SIDE; j++)
        {
            for (int k=0; k<SIDE; k++)
            {
                newArr[i][j][k] = arr[i][SIDE - j - 1][k];
            }
        }
    }
}

void transpose(const uint8_t arr[SIDE][SIDE][3], uint8_t newArr[SIDE][SIDE][3])
{
    for (int i=0; i<SIDE; i++)
    {
        for (int j=0; j<SIDE; j++)
        {
            for (int k=0; k<3; k++)
            {
                newArr[i][j][k] = arr[j][i][k];
            }
        }
    }
}
    
void unionArr(const uint8_t arr1[SIDE][SIDE][3], const uint8_t arr2[SIDE][SIDE][3], uint8_t newArr[SIDE][SIDE][3], int ya1, int yb1, int xa1, int xb1, int ya2, int yb2, int xa2, int xb2,cCode colorCode)
{
    Serial debug(USBTX,USBRX);
    uint8_t colors[3] = {0,0,0};
    switch (colorCode)
    {
        case wh:
        debug.printf("wh\n\r");
        colors[0] = 255;
        colors[1] = 255;
        colors[2] = 255;
        break;
        case bl:
        debug.printf("bl\n\r");
        colors[0] = 0;
        colors[1] = 0;
        colors[2] = 0;
        break;
        case re:
        colors[0] = 255;
        colors[1] = 0;
        colors[2] = 0;
        break;
        case gr:
        colors[0] = 0;
        colors[1] = 255;
        colors[2] = 0;
        break;
        case bu:
        colors[0] = 0;
        colors[1] = 0;
        colors[2] = 255;
        break;
        case ye:
        colors[0] = 255;
        colors[1] = 255;
        colors[2] = 0;
        break;
        case cy:
        colors[0] = 0;
        colors[1] = 255;
        colors[2] = 255;
        break;
        case ma:
        colors[0] = 255;
        colors[1] = 0;
        colors[2] = 255;
        break;
        default:
        colors[0] = 255;
        colors[1] = 255;
        colors[2] = 255;
        break;
    }
    for (int i=0; i<SIDE; i++)
    {
        for (int j=0; j<SIDE; j++)
        {
            for (int k=0; k<3; k++)
            {
                newArr[i][j][k] = colors[k];
            }
        }
    }
    for (int i=xa1; i<xb1; i++)
    {
        for (int j=ya1; j<yb1; j++)
        {
            for (int k=0; k<3; k++)
            {
                newArr[i][j][k] = arr1[i][j][k];
            }
        }
    }
    for (int i=xa2; i<xb2; i++)
    {
        for (int j=ya2; j<yb2; j++)
        {
            for (int k=0; k<3; k++)
            {
                newArr[i][j][k] = arr2[i][j][k];
            }
        }
    }
}

void unionArr(const uint8_t arr1[SIDE][SIDE][3], const uint8_t arr2[SIDE][SIDE][3], uint8_t newArr[SIDE][SIDE][3], int ya1, int yb1, int xa1, int xb1, int ya2, int yb2, int xa2, int xb2)
{
    Serial debug(USBTX,USBRX);
    for (int i=0; i<SIDE; i++)
    {
        for (int j=0; j<SIDE; j++)
        {
            for (int k=0; k<3; k++)
            {
                newArr[i][j][k] = 0;
            }
        }
    }
    for (int i=xa1; i<xb1; i++)
    {
        for (int j=ya1; j<yb1; j++)
        {
            for (int k=0; k<3; k++)
            {
                newArr[i][j][k] = arr1[i][j][k];
            }
        }
    }
    for (int i=xa2; i<xb2; i++)
    {
        for (int j=ya2; j<yb2; j++)
        {
            for (int k=0; k<3; k++)
            {
                newArr[i][j][k] = arr2[i][j][k];
            }
        }
    }
}

void letterShift(const uint8_t arr[SIDE][SIDE][3], uint8_t nArr[SIDE][SIDE][3], int offset, cCode colorCode)
{
    uint8_t larr[SIDE][SIDE][3];
    uint8_t rarr[SIDE][SIDE][3];
    translate_h(arr,rarr,(SIDE/2) + offset,colorCode);
    translate_h(arr,larr,-(SIDE/2) + offset,colorCode);
    for (int i=0; i<SIDE/2; i++)
    {
        for (int j=0; j<SIDE; j++)
        {
            for (int k=0; k<3; k++)
            {
                nArr[j][i][k] = larr[j][i+(SIDE/2)][k];
            }
        }
    }
    for (int i=SIDE/2; i<SIDE; i++)
    {
        for (int j=0; j<SIDE; j++)
        {
            for (int k=0; k<3; k++)
            {
                nArr[j][i][k] = rarr[j][i-(SIDE/2)][k];
            }
        }
    }
}
#endif