

/* Chip defines */
#define ACC 0x32
#define MAG 0x3C

/* Read */
#define I2CR 0x01
/* Write */
#define I2CW 0x00
/* Multiple Transfer */
#define MTRAN 0x80

/* accelerometer register defines */
#define CTRL_REG1_A 0x20
#define OUT_X_L_A 0x28
#define OUT_X_H_A 0x29
#define OUT_Y_L_A 0x2A
#define OUT_Y_H_A 0x2B
#define OUT_Z_L_A 0x2C
#define OUT_Z_H_A 0x2D

/* magnetometer register defines */
#define CRB_REG_M 0x01
#define MR_REG_M 0x02
#define OUT_X_H_M 0x03
#define OUT_X_L_M 0x04
#define OUT_Y_H_M 0x05
#define OUT_Y_L_M 0x06
#define OUT_Z_H_M 0x07
#define OUT_Z_L_M 0x08


/* Activate the accelerometer */
void startAcc(I2C i2c)
{
    i2c.start();
    i2c.write(ACC | I2CW);
    i2c.write(CTRL_REG1_A);
    i2c.write(0x37);
    i2c.stop();
}

/* Activate the magnetometer */
void startMag(I2C i2c)
{
    i2c.start();
    i2c.write(MAG | I2CW);
    i2c.write(CRB_REG_M);
    i2c.write(0x20);
    i2c.stop();
    i2c.start();
    i2c.write(MAG | I2CW);
    i2c.write(MR_REG_M);
    i2c.write(0x00);
    i2c.stop();
}

void readAcc(I2C i2c, char registers[6], int16_t *xacc, int16_t *yacc, int16_t *zacc)
{
    uint8_t DATA[6];
    uint8_t SUB = registers[0];
    uint8_t SAD = ACC;
    i2c.start();
    i2c.write(SAD | I2CW);
    i2c.write(SUB | MTRAN);
    i2c.start();
    i2c.write(SAD | I2CR);
    DATA[0] = i2c.read(1);
    DATA[1] = i2c.read(1);
    DATA[2] = i2c.read(1);
    DATA[3] = i2c.read(1);
    DATA[4] = i2c.read(1);
    DATA[5] = i2c.read(0);
    i2c.stop();
    *xacc = DATA[1]*256+DATA[0];
    *yacc = DATA[3]*256+DATA[2];
    *zacc = DATA[5]*256+DATA[4];
}

void readMag(I2C i2c, char registers[6], int16_t *xmag, int16_t *ymag, int16_t *zmag)
{
    uint8_t DATA[6];
    uint8_t SUB = registers[0];
    uint8_t SAD = MAG;
    i2c.start();
    i2c.write(SAD | I2CW);
    i2c.write(SUB | MTRAN);
    i2c.start();
    i2c.write(SAD | I2CR);
    DATA[0] = i2c.read(1);
    DATA[1] = i2c.read(1);
    DATA[2] = i2c.read(1);
    DATA[3] = i2c.read(1);
    DATA[4] = i2c.read(1);
    DATA[5] = i2c.read(0);
    i2c.stop();
    *xmag = DATA[0]*256+DATA[1];
    *ymag = DATA[2]*256+DATA[3];
    *zmag = DATA[4]*256+DATA[5];
}