/**
 * @file main.cpp
 * @brief interface configuration & main loop start
 * Copyright 2015 SEVENCORE Co., Ltd.
 *
 * @author HyeongJun Kim 
 * @version 1.0.0  
 * @since 2015-08-17
*/


#include "mbed.h"
#include "BleMsgHandler.h"
#include "app.h"

Serial hostpc(USBTX,USBRX);
Serial device(p13,p14);
LocalFileSystem local("local");               // Create the local filesystem
DigitalOut myled(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);

using namespace sevencore_fota;

void led_setting_one(void){
    myled = 1;
    myled2 = 1;
    myled3 = 1;
    myled4 = 1;
}

void led_setting_zero(void){
    myled = 0;
    myled2 = 0;
    myled3 = 0;
    myled4 = 0;
}

int main() {
    wait(0.5);
    myled = 1;
    wait(0.5);
    myled = 0;
    wait(0.5);
    myled = 1;
    wait(0.5);
    myled = 0;
    wait(0.5);
    led_setting_one(); 
    wait(0.5);
    hostpc.baud(9600);
    wait(0.5);
    device.baud(115200);
    device.set_flow_control(device.RTSCTS,P2_7,p12);
    wait(0.5);
    
    BleMsgHandler myfota(&device,&hostpc);   
    
    myfota.PrintTitle();
    app_rst_gap(&myfota);
    
    for(int i = 0; i < 200; i++) {
        myfota.BleReceiveMsg();
        myfota.BleMsgHandle();
    }
    
    while(1) {
        myled = 1;
        wait(0.5);
        myled = 0;
        wait(0.5);
    }
    
}
