/**
 * @file SerialManager.h
 * @brief Serial Communication Management 
 * Copyright 2015 SEVENCORE Co., Ltd.
 *
 * @author HyeongJun Kim 
 * @version 1.0.0  
 * @date 2015-08-19
*/
#ifndef SERIALMANAGER_H
#define SERIALMANAGER_H

#include "mbed.h"
/**
 ****************************************************************************************
 * @addtogroup ext_fota module
 * @brief Serial Manager Class Header.
 *
 * @{
 ****************************************************************************************
 */
namespace sevencore_fota{
    
class SerialManager
{
public:
    /**
     ****************************************************************************************
     * @brief Serial Manager constructor only connected Device
     ****************************************************************************************
     */ 
    SerialManager(Serial *_device);
    /**
     ****************************************************************************************
     * @brief Serial Manager constructor with connected Device & HostPC
     ****************************************************************************************
     */
    SerialManager(Serial *_device,Serial *_hostpc);
    /**
     ****************************************************************************************
     * @brief Serial Manager destructor
     ****************************************************************************************
     */
    ~SerialManager(void);
    /**
     ****************************************************************************************
     * @brief Send ble message to serial port
     ****************************************************************************************
     */
    int SendToSerial(uint8_t *data,unsigned short size);
    /**
     ****************************************************************************************
     * @brief Receive ble message from serial port
     ****************************************************************************************
     */
    int ReceiveToSerial(unsigned char *receive_msg);
    /**
     ****************************************************************************************
     * @brief Receive data for size
     ****************************************************************************************
     */
    void DataReceive(uint8_t *databuf, unsigned short size);
    /**
     ****************************************************************************************
     * @brief Receive data test function
     ****************************************************************************************
     */
    void ReceiveToSerialTest(void);  
      
private:
    /**
     ****************************************************************************************
     * @brief Serial Manager Start title print function.
     ****************************************************************************************
     */
    void PrintSerialManager(void);
    
    bool print_flag;
    Serial *device;
    Serial *hostpc;
    uint8_t FE_MSG_PACKET_TYPE;
    int MAX_PACKET_LENGTH;
    unsigned char bReceiveState;
    unsigned short wDataLength;
    unsigned short wReceivePos;
    unsigned char bHdrBytesRead;
    unsigned char bReceiveElementArr[512];

};

}//namespace

/// @} ext_fota module
#endif//SERIALMANAGER_H
