/**
 * @file dialog_fota_config.h
 * @brief Compile configuration file.
 * Copyright 2015 SEVENCORE Co., Ltd.
 *
 * @author HyeongJun Kim 
 * @version 1.0.0  
 * @date 2015-08-20
*/
#ifndef DIALOG_FOTA_CONFIG_H
#define DIALOG_FOTA_CONFIG_H
#include "mbed.h"
/**
 ****************************************************************************************
 * @addtogroup dialog_fota module
 * @brief Compile configuration.
 *
 * @{
 ****************************************************************************************
 */
namespace sevencore_fota{

#define BD_ADDR_LEN         0x06
#define ADV_DATA_LEN        0x1F
#define SCAN_RSP_DATA_LEN   0x1F

#define CO_ERROR_NO_ERROR                        0x00


enum KE_TASK_TYPE
{
    TASK_NONE = 0xFF,

    // Link Layer Tasks
    TASK_LLM          = 0   ,
    TASK_LLC          = 1   ,
    TASK_LLD          = 2   ,
    TASK_DBG          = 3   ,

    TASK_L2CM         = 4   ,
    TASK_L2CC         = 5   ,
    TASK_SMPM         = 6   ,
    TASK_SMPC         = 7   ,
    TASK_ATTM         = 8   ,   // Attribute Protocol Manager Task
    TASK_ATTC         = 9   ,   // Attribute Protocol Client Task
        
    TASK_ATTS         = 10  ,   // Attribute Protocol Server Task
    TASK_GATTM        = 11  ,   // Generic Attribute Profile Manager Task
    TASK_GATTC        = 12  ,   // Generic Attribute Profile Controller Task
    TASK_GAPM         = 13  ,   // Generic Access Profile Manager
    TASK_GAPC         = 14  ,   // Generic Access Profile Controller
    
    TASK_PROXM        = 15  ,   // Proximity Monitor Task
    TASK_PROXR        = 16  ,   // Proximity Reporter Task
    TASK_FINDL        = 17  ,   // Find Me Locator Task
    TASK_FINDT        = 18  ,   // Find Me Target Task
    TASK_HTPC         = 19  ,   // Health Thermometer Collector Task
    TASK_HTPT         = 20  ,   // Health Thermometer Sensor Task
    TASK_ACCEL        = 21  ,   // Accelerometer Sensor Task
    TASK_BLPS         = 22  ,   // Blood Pressure Sensor Task
    TASK_BLPC         = 23  ,   // Blood Pressure Collector Task
    TASK_HRPS         = 24  ,   // Heart Rate Sensor Task
    TASK_HRPC         = 25  ,   // Heart Rate Collector Task
    TASK_TIPS         = 26  ,   // Time Server Task
    TASK_TIPC         = 27  ,   // Time Client Task
    TASK_DISS         = 28  ,   // Device Information Service Server Task
    TASK_DISC         = 29  ,   // Device Information Service Client Task
    TASK_SCPPS        = 30  ,   // Scan Parameter Profile Server Task
    TASK_SCPPC        = 31  ,   // Scan Parameter Profile Client Task
    TASK_BASS         = 32  ,   // Battery Service Server Task
    TASK_BASC         = 33  ,   // Battery Service Client Task
    TASK_HOGPD        = 34  ,   // HID Device Task
    TASK_HOGPBH       = 35  ,   // HID Boot Host Task
    TASK_HOGPRH       = 36  ,   // HID Report Host Task
    TASK_GLPS         = 37  ,   // Glucose Profile Sensor Task
    TASK_GLPC         = 38  ,   // Glucose Profile Collector Task
    TASK_NBPS         = 39  ,   // Nebulizer Profile Server Task
    TASK_NBPC         = 40  ,   // Nebulizer Profile Client Task
    TASK_RSCPS        = 41  ,   // Running Speed and Cadence Profile Server Task
    TASK_RSCPC        = 42  ,   // Running Speed and Cadence Profile Collector Task
    TASK_CSCPS        = 43  ,   // Cycling Speed and Cadence Profile Server Task
    TASK_CSCPC        = 44  ,   // Cycling Speed and Cadence Profile Client Task
    TASK_ANPS         = 45  ,   // Alert Notification Profile Server Task
    TASK_ANPC         = 46  ,   // Alert Notification Profile Client Task
    TASK_PASPS        = 47  ,   // Phone Alert Status Profile Server Task
    TASK_PASPC        = 48  ,   // Phone Alert Status Profile Client Task

    TASK_LANS         = 49  ,   // Location and Navigation Profile Server Task
    TASK_APP          = 50  ,   // Do not Alter. 

    TASK_LANC         = 51  ,   // Location and Navigation Profile Client Task

    TASK_CPPS         = 52  ,   // Cycling Power Profile Server Task
    TASK_CPPC         = 53  ,   // Cycling Power Profile Client Task
    
    // Start of conditionally assigned task types
    TASK_FOTA_SERVER    = 54  ,
    
#if (BLE_SAMPLE128)
    TASK_SAMPLE128    ,   // Sample128 Task
#endif

#if (BLE_SPOTA_RECEIVER)
    TASK_SPOTAR       ,   // SPOTA Receiver task
#endif

#if (BLE_STREAMDATA_DEVICE)
    TASK_STREAMDATAD  ,   // Stream Data Device Server task
#endif

#if (BLE_STREAMDATA_HOST)
    TASK_STREAMDATAH  ,   // Stream Data Device Server task
#endif

#if (BLE_ANC_CLIENT)
    TASK_ANCC         ,   // ANCS Client Task
#endif

#if (BLE_WPT_CLIENT)
    TASK_WPTC         ,   // A4WP Wireless Power Transfer Client Profile Task
#endif

#if (BLE_WPTS)
    TASK_WPTS         ,   // A4WP Wireless Power Transfer Server Profile Task
#endif

#if (BLE_APP_PTU)
     TASK_APP_PTU     ,   // A4WP Wireless Power Transfer Client App Task
#endif

#if (BLE_IEU)
    TASK_IEU          ,   // Integrated Environmantal Unit Task
#endif

#if (BLE_MPU)
    TASK_MPU          ,   // Motion Processing Unit Task
#endif

#if (BLE_WSS_SERVER)
    TASK_WSSS          ,   // Weight Scale Server Task
#endif

#if (BLE_UDS_SERVER)
    TASK_UDSS          ,   // User Data Server Task
#endif

#if (BLE_SPS_SERVER)
    TASK_SPS_SERVER    ,   // Serial Proert Service Server Task
#endif

#if (BLE_SPS_CLIENT)
    TASK_SPS_CLIENT    ,   // Serial Proert Service Server Task
#endif

#if (BLE_ADC_NOTIFY)
    TASK_ADC_NOTIFY    ,   // Serial Proert Service Server Task
#endif

#if (BLE_DEVICE_CONFIG)
    TASK_DEVICE_CONFIG    ,   // Serial Proert Service Server Task
#endif

    // End of conditionally assigned task types

    TASK_HCI          = 60  ,
    TASK_HCIH         = 61  ,

    TASK_GTL          = 63  ,

#if (USE_AES)
    TASK_AES          = 62  ,   // Task for asynchronous AES API
#endif    

    TASK_MAX          = 64,  //MAX is 64. Do  not exceed. 
};


///BD Address structure
struct bd_addr
{
    ///6-byte array address value
    uint8_t  addr[BD_ADDR_LEN];
};


///Advertising report structure
struct adv_report
{
    ///Event type:
    /// - ADV_CONN_UNDIR: Connectable Undirected advertising
    /// - ADV_CONN_DIR: Connectable directed advertising
    /// - ADV_DISC_UNDIR: Discoverable undirected advertising
    /// - ADV_NONCONN_UNDIR: Non-connectable undirected advertising
    uint8_t        evt_type;
    ///Advertising address type: public/random
    uint8_t        adv_addr_type;
    ///Advertising address value
    struct bd_addr adv_addr;
    ///Data length in advertising packet
    uint8_t        data_len;
    ///Data of advertising packet
    uint8_t        data[ADV_DATA_LEN];
    ///RSSI value for advertising packet
    uint8_t        rssi;
};

/// Connection type
enum prf_con_type
{
    ///Discovery type connection
    PRF_CON_DISCOVERY = 0x00,
    /// Normal type connection
    PRF_CON_NORMAL    = 0x01,
};

}//namespace

/// @} dialog_fota module

#endif//DIALOG_FOTA_CONFIG_H
