//Importieren der Standardbefehle
#include "mbed.h"

//Deffinieren von Ein-/Ausgängen
BusOut leds(P1_13,P1_12,P1_7,P1_6,P1_4,P1_3,P1_1,P1_0,LED4,LED3,LED2,LED1); //Bus (Mehrere Eingänge zusammenfassen), Out (Als Ausgang definieren), leds (Name der Variable), ... (Pins aus der zusammenfassung wählen und eintragen)
DigitalIn btn1(P0_10); //Digital (nur 1 oder 0), In (Eingang), btn (Name der Varibale), P0_16 (Pin, an der der Button angeschlossen ist)
InterruptIn btn2(P1_16), btn3(P0_23); //Interrupt (Wenn sich der Eingang verändert [Rise 0->1, Fall 1->0]), In (Eingang)] ...

//Definieren von Variablen
int btn3pressed = 0, temp = 0; //Variablen für das Speichern, ob btn3 gedrückt wurde

Timer T1;  //Timer definieren (Zähler der im hintergrund von 0ms hoch zählt)

void sw4ISR(); //Definieren der Interrupt Klassen
void sw3ISR(); //...
int sw3CheckFlag(); //Definieren einer Abfrageklasse

//Hauptmethode
int main() {
    //Initialisierung
    btn2.rise(sw4ISR); //Definieren der Interrupts als rise, sw4ISR ist die Methode, die Aufgerufen wird) 
    btn3.rise(sw3ISR); //...
    
    T1.start(); //Starten des 1. Timers
    leds=1; //Aktivieren der 1. LED am LED-Balken
    wait_ms(500); //Warten 0,5s
    
    //Dauerschleife
    while(1) {
        leds = leds << 1; //Verschieben der LEDs, << nach links (0001 -> 0010), >> nach rechts (0100->0010), null wird nachgeschoben
        
        if(btn1 || sw3CheckFlag()){  // Prüfen, ob der 1. Button gedrückt ist oder btn3 seit dem letzten mal gedrückt wurde
            leds=1;     //Zurücksetzen des LED-Balkens
            T1.reset(); //Zurücksetzen des Timers
        } 
        if(T1.read_ms() > 10000){   //Prüfen ob der Timer mehr als 10s läuft
           T1.reset();      //Zurücksetzen des Timers
           leds=1;          //Zurücksetzen des LED-Balkens
        }
        
        wait_ms(2000); //2s Warten
        
    }
}

//Interrupt Klassen
//Button 4 gedrückt -> direkter Einfluss auf den LED Balken
void sw4ISR(){
    leds=1;     //Zurücksetzen des LED-Balkens
    T1.reset(); //Zurücksetzen des Timers
}

//Button 3 gedrückt -> Speichern des Drucks
void sw3ISR(){
    btn3pressed = 1;
}

//Abfrage, ob btn3 gedrückt wurde
int sw3CheckFlag(){
    temp = btn3pressed; //zuwischenspeichern der Variable (btn3pressed muss vor dem "return" zurückgesetzt werden)
    btn3pressed = 0;    //btn3pressed zurücksetzen
    return temp;        //Rückgabe von 1 oder 0, je nach dem, ob btn3 gedrückt wurde
}