/*
*   FSST-Test
*   von Marcel Schreiner
*/

#include "mbed.h"
#include "BtnEventM0.h"

//        LSB                                                      MSB
//        2^0   2^1   2^2                                          2^11
BusOut lb(P1_13,P1_12,P1_7,P1_6,P1_4,P1_3,P1_1,P1_0,LED4,LED3,LED2,LED1);
//        D20   D19   D18  D17  D16  D15  D14  D13  D4   D3   D2   D1

BtnEventM0 Btn1(P1_16);

class RGBStm {
    public:
        void Init() {
            state=1; 
            Timer T1;
            Timer T2;
        }
        void Red();
        void Blue();
        void Green();
    public:
        void RedAction();
        void BlueAction();
        void GreenAction();
    public:
    int state;
};

RGBStm rgb;

int main()
{
    Btn1.Init();
    rgb.Init();
    T2.start();
  while(1){
    switch(state){
        case 1:
            rgb.Red();
            break;
        case 2:
            rgb.Blue();
            break;
        case 3:
            rgb.Green();
            break;  
    }
  }
}
void RGBStm::Red(){
    T1.reset();
    T1.start();
    lb = 1 << 11;
    while(
        if(T1.read_ms()>1000){
            T1.reset();
            if(lb == 0)lb = 1 << 11;
            else lb = 0;
        }
        if(Btn1.CheckFlag()){
            T1.stop();
            state = 2;
            return;
        }
    }
}
void RGBStm::Blue(){
    T2.reset();
    T1.reset();
    T1.start();
    lb = 1 << 9;
    while(
        if(T1.read_ms()>500){
            T1.reset();
            if(lb == 0)lb = 1 << 9;
            else lb = 0;
        }
        if(Btn1.CheckFlag()){
            T2.stop();
            T1.stop();
            state = 3;
            return;
        }
        if(T2.read_ms()>3000){
            T2.stop();
            T1.stop();
            state = 1;
            return;
        }
    }
}
void RGBStm::Green(){
    T2.reset();
    T1.reset();
    T1.start();
    lb = 1 << 7;
    while(
        if(T1.read_ms()>100){
            T1.reset();
            if(lb == 0)lb = 1 << 7;
            else lb = 0;
        }
        if(Btn1.CheckFlag()){
            T1.stop();
            T2.stop();
            state = 1;
            return;
        }
        if(T2.read_ms() > 2000){
            T2.stop();
            T1.stop();
            state = 2;
            return;
        }
    }
}