/*
Copyright: Antonio Vlasic
1997 - heute
*/

#include "mbed.h"
#include "BtnEventM0.h"

BusOut lb(P1_7,P1_6,P1_4,P1_3,P1_1,P1_0,LED4,LED3,LED2,LED1);   //Ledbar definieren ohne P1_13 und P1_12
BusOut stLED(P1_13,P1_12);                                      //P1_13 und P1_12 definieren

BtnEventM0 Btn1(P0_15), Btn2(P0_23);                            //2 Buttons unter einer Custom Library definieren

//Custom Library: BtnEventM0.h

class FahrradLeuchte {                          //Eine Klasse namens FahrradLeuchte
    public:                                     //Öffentlich
        void Init() { state=1; t1.start(); }    //Beim Aufrufen wird der Status auf 1 gesetzt und der Timer t1 gestartet
        void State1Func();                      //Funktion definieren
        void State2Func();                      //Funktion definieren
        void State3Func();                      //Funktion definieren
    public:                                     //Öffentlich
        void State1Action();                    //Funktion definieren
        void State2Action();                    //Funktion definieren
        void State3Action();                    //Funktion definieren
    public:                                     //Öffentlich
        int state;                              //Integer state definieren
        Timer t1;                               //Timer t1 definieren
};

FahrradLeuchte fl;                              //Klasse als Variabel aktivieren

int main() {                                    //Main-Funktion
    lb=0;                                       //Gesamte Ledbar auf 0 setzen
    Btn1.Init(); Btn2.Init();                   //Btn1 und Btn2 mit Init() ansprechen
    fl.Init();                                  //Die Fahrradleuchte mit Init() ansprechen
    while(1)                                    //Die ganze Zeit durchlaufen
    {
        if( fl.state==1 )                       //Wenn der Status der Fahrradleuchte 1 ist
            fl.State1Func();                    //Funktion State1Func unter der Klasse FahrradLeuchte starten
        if( fl.state==2 )                       //Wenn der Status der Fahrradleuchte 2 ist
            fl.State2Func();                    //Funktion State2Func unter der Klasse FahrradLeuchte starten
        if( fl.state==3 )                       //Wenn der Status der Fahrradleuchte 3 ist
            fl.State3Func();                    //Funktion State3Func unter der Klasse FahrradLeuchte starten
    }
}

void FahrradLeuchte::State1Func()               //Funktion State1Func() der Klasse FahrradLeuchte definieren
{
    t1.reset();                                 //Timer t1 reseten
    stLED = 1;                                  //Binärstatus 1 mit Leds anzeigen
    while(1)                                    //Während die Funktion aufgerufen wird
    {
        State1Action();                         //Function State1Action() aufrufen
        if( Btn1.CheckFlag() )                  //Wenn der erste Button geklickt wird
            { state=2; return; }                //state = 2
        if( Btn2.CheckFlag() )                  //Wenn der zweite Button geklickt wird
            { state=3; return; }                //state = 3
    }
}

void FahrradLeuchte::State2Func()               //Funktion State2Func() der Klasse FahrradLeuchte definieren (Rest siehe oben)
{
    t1.reset();
    stLED = 2;
    while(1)
    {
        State2Action();
        if( Btn1.CheckFlag() )
            { state=3; return; }
        if( Btn2.CheckFlag() )
            { state=1; return; }
    }
}

void FahrradLeuchte::State3Func()               //Funktion State3Func() der Klasse FahrradLeuchte definieren (Rest siehe oben)
{
    t1.reset();
    stLED = 3;
    while(1)
    {
        State3Action();
        if( Btn1.CheckFlag() )
            { state=1; return; }
        if( Btn2.CheckFlag() )
            { state=2; return; }
    }
}

void FahrradLeuchte::State1Action()             //Funktion State1Action() der Klasse FahrradLeuchte definieren
{
    if( t1.read_ms()<500 )                      //Solande t1 kleiner als 0.5 Sekunden ist
        return;                                 //Ende der Funktion
    t1.reset();                                 //Wenn größer: Timer t1 reseten
    if( lb==0 )                                 //wenn die Ledbar auf dem Status 0 ist
        lb = 512;                               //Der 3. Led von hinten der Ledbar aufleuchten lassen
    else                                        //Sonst
        lb = 0;                                 //Ledbar auf 0 setzen
}

void FahrradLeuchte::State2Action()             //Funktion State1Action() der Klasse FahrradLeuchte definieren (Rest siehe oben)
{
    if( t1.read_ms()<200 )
        return;
    t1.reset();
    if( lb==0 )
        lb = 256;
    else
        lb = 0;
}

void FahrradLeuchte::State3Action()             //Funktion State1Action() der Klasse FahrradLeuchte definieren (Rest siehe oben)
{
    if( t1.read_ms()<100 )
        return;
    t1.reset();
    if( lb==0 )
        lb = 128;
    else
        lb = 0;
}