
#include "mbed.h"
#include "BtnEventM0.h"

BusOut lb(P1_7,P1_6,P1_4,P1_3,P1_1,P1_0,LED4,LED3,LED2,LED1);   //Ledbar definieren ohne P1_13 und P1_12
BusOut stLED(P1_13,P1_12);                                      //P1_13 und P1_12 definieren

Serial pc(USBTX, USBRX);                                        //ein serielles Objekt anlegen
BtnEventM0 Btn1(P0_15), Btn2(P0_23);                            //2 Buttons unter einer Custom Library definieren

//Custom Library: BtnEventM0.h

class Ampel
{
public:
    void Init() {
        state=1;
        t1.start();
        t2.start();
        t3.start();
    }

    void rot();
    void gelb();
    void gruen();
    void gruen_bl();
public:
    void rotAction();
    void gelbAction();
    void gruenAction();
    void gruen_blAction();
public:
    //state sagt uns in welchem Zustand sich die Ampel gerade befindet
    int state;
    Timer t1; 
    Timer t2;
    Timer t3;

} ;


Ampel amp;

int main()                                      //Main-Funktion
{
    pc.baud(125000);                           // auf 125000 Bits/sec setzen
    Btn1.Init();
    amp.Init();                                 //Btn1 und Btn2 mit Init() ansprechen
    while(1) {                                  //Die ganze Zeit durchlaufen
        if( amp.state==1 )
            amp.rot();
        if( amp.state==2 )
            amp.gelb();
        if( amp.state==3 )
            amp.gruen();
        if( amp.state==4 )
            amp.gruen_bl();

        amp.state=1;
    }

}


void Ampel::rot()
{
    pc.printf("ROT\n");
    t3.reset();
    while(1) {

        if(t3.read_ms()>3200) { // 3 sec sind abgelaufen
            state=2;
            return;
        }
        if(Btn1.CheckFlag()) {
            state=1;
            return;
        }
        rotAction();
    }


}
void Ampel::rotAction()
{
    if(t1.read_ms()>200) {   //Blinken
        t1.reset();

        if (lb==0)
            lb=1;
        else
            lb=0;
    }
    if(t2.read_ms()>100) {
        t2.reset();
        pc.printf("2 %d \n" , t3.read_ms());

    }
}

void Ampel::gelb()
{
    pc.printf("gelb\n");
    t3.reset();
    while(1) {

        if(t3.read_ms()>4200) { // 3 sec sind abgelaufen
            state=3;
            return;
        }
        if(Btn1.CheckFlag()) {
            state=4;
            return;
        }
        gelbAction();
    }

}

void Ampel::gelbAction()
{
    if(t1.read_ms()>200) {   //Blinken
        t1.reset();

        if (lb==0)
            lb=2;
        else
            lb=0;
    }
    if(t2.read_ms()>100) {
        t2.reset();
        pc.printf("2 %d \n" , t3.read_ms());

    }
}

void Ampel::gruen()
{
    pc.printf("gruen \n");
    t3.reset();
    while(1) {

        if(t3.read_ms()>5200) { // 3 sec sind abgelaufen
            state=3;
            return;
        }
        if(Btn1.CheckFlag()) {
            state=4;
            return;
        }
        gruenAction();



    }

}

void Ampel::gruenAction()
{
    if(t1.read_ms()>200) {   //Blinken
        t1.reset();

        if (lb==0)
            lb=4;
        else
            lb=0;
    }
    if(t2.read_ms()>100) {
        t2.reset();
        pc.printf("2 %d \n" , t3.read_ms());

    }

}

void Ampel::gruen_bl()
{
    pc.printf("gruen BLinken \n");
    t3.reset();
    while(1) {

        if(t3.read_ms()>5200) { // 3 sec sind abgelaufen
            state=1;
            return;
        }

        gruen_blAction();



    }

}
void Ampel::gruen_blAction()
{
    if(t1.read_ms()>200) {   //Blinken
        t1.reset();

        if (lb==0)
            lb=3;
        else
            lb=0;
    }
    if(t2.read_ms()>100) {
        t2.reset();
        pc.printf("2 %d \n" , t3.read_ms());

    }

}
