#include "mbed.h"
#include "BtnEventM0.h"

BusOut lb(LED3,LED2,LED1);                                                          //Kleine Ledbar (In Verwendung)
PwmOut g(p5), b(p34), r(p36);

BusOut lbrest(P1_13,P1_12,P1_7,P1_6,P1_4,P1_3,P1_1,P1_0,LED4);                      //Rest der ausgeschalten wird (Standardmäßig auf 1)

BtnEventM0 Btn1(P0_15);                                                             //Button zum Reseten

class Ampel                                                                         //Ampelklasse
{
public:
    void Init() {
        state=1;
        t1.start();
        t2.start();
        t3.start();
    }
    void Rot();                                                                 //Funktion Rot
    void Gelb();                                                                //Funktion Gelb
    void Gruen();                                                               //Funktion Grün
public:
    void RotAction();                                                           //Action Rot
    void GelbAction();                                                          //Action Gelb
    void GruenAction();                                                         //Action Gruen
public:
    int state;                                                                  //Statusvariabel
    Timer t1, t2, t3;                                                           //Timer t1, t2 und t3
};

Ampel amp;                                                                          //Ampelklasse als Variabel aktivieren

int main()                                                                          //Hauptfunktion
{
    lb=0;                                                                           //Ledbar auf 0 setzen
    g=255;
    b=255;
    r=255;
    lbrest=0;                                                                       //Ledbar auf 0 setzen
    Btn1.Init();                                                                    //Button mit Funktion Init ansprechen
    amp.Init();                                                                     //Ampelvariabel mit Funktion Init ansprechen
    while(1) {                                                                      //Solange die Funktion aufgerufen wird
        if( amp.state==1 )                                                          //Funktion auf state abstimmen
            amp.Rot();
        if( amp.state==2 )
            amp.Gelb();
        if( amp.state==3 )
            amp.Gruen();
        if( amp.state==4 )
            amp.Gelb();
    }
}

void Ampel::Rot()                                                                   //Funktion der Klasse Ampel
{
    t1.reset();                                                                     //Reseten
    t2.reset();                                                                     //Reseten
    t3.reset();                                                                     //Reseten
    while(1) {
        RotAction();                                                                //RotAction aufrufen
        if( Btn1.CheckFlag() ) {                                                    //Bei einem Buttonclick
            state=1;    //state = 1
            return;
        }
    }
}

void Ampel::Gelb()                                                                  //Funktion der Klasse Ampel
{
    t1.reset();                                                                     //Reseten
    t2.reset();                                                                     //Reseten
    t3.reset();                                                                     //Reseten
    while(1) {
        GelbAction();                                                               //GelbAction aufrufen
        if( Btn1.CheckFlag() ) {                                                    //Bei einem Buttonclick
            state=1;    //state = 1
            Rot();
            return;
        }
    }
}

void Ampel::Gruen()                                                                 //Funktion der Klasse Ampel
{
    t1.reset();                                                                     //Reseten
    t2.reset();                                                                     //Reseten
    t3.reset();                                                                     //Reseten
    while(1) {
        GruenAction();                                                              //GruenAction aufrufen
        if( Btn1.CheckFlag() ) {                                                    //Bei einem Buttonclick
            state=1;    //state = 1
            Rot();
            return;
        }
    }
}

void Ampel::RotAction()                                                             //Funktion der Klasse Ampel
{
    if( t1.read_ms()<3000 ) {                                                       //Solange der Timer unter 3 Sekunden ist
        lb=1;
        g=255;
        b=255;
        r=0;                                                                       //Ledbar auf 1
        return;                                                                     //Funktionsabbruch
    }
    state=2;                                                                        //state = 2
    Gelb();                                                                         //Funktion Gelb aufrufen
}

void Ampel::GelbAction()                                                            //Funktion der Klasse Ampel
{
    if( t2.read_ms()<1000 ) {                                                       //Solange der Timer unter 1 Sekunden ist
        lb=2;
        g=0;
        b=255;
        r=0;                                                                        //Ledbar auf 2
        return;                                                                     //Funktionsabbruch
    }
    if(state==2) {
        state=3;                                                                    //state = 3
        Gruen();                                                                    //Funktion Gruen aufrufen
    } else {
        state=1;                                                                    //state = 1
        Rot();                                                                      //Funktion Rot aufrufen
    }
}

void Ampel::GruenAction()                                                           //Funktion der Klasse Ampel
{
    if( t3.read_ms()<3000 ) {                                                       //Solange der Timer unter 3 Sekunden ist
        lb=4;
        g=0;
        b=255;
        r=255;                                                                        //Ledbar auf 4
        return;                                                                     //Funktionsabbruch
    }
    state=4;                                                                        //state = 4
    Gelb();                                                                         //Funktion Gelb aufrufen
}