#include "mbed.h"
#include "Motor.h"
#include "pinconfig.h"
#include "eeprom.h"

Serial rd(D1,D0);
Serial pc(D8,D2);
AnalogIn Ain1(PC_2);
AnalogIn Ain2(PC_3);
DigitalIn enable(PB_7);
DigitalIn enable1(PC_13);
EEPROM memory(PB_4,PA_8,0);
DigitalOut dout(LED1);

int main(void)
{
    Motor Upper1(PWM_LU,A_LU,B_LU );
    Motor Upper2(PWM_LL,A_LL,B_LL );
    Upper1.period(0.00001);
    Upper2.period(0.00001);
    uint8_t data;
    //  uint8_t sw= Switch.read();

    float x,j;
    float y,j1;
    int k;
    rd.printf("Hello World !\n");

    while(1) {
        data = pc.getc();
        rd.printf("%c",data);
        rd.printf("\n");
        wait_ms(100);
        
        switch(data) {

            case'u':
                pc.printf("Motor up left\n");
                Upper1.speed(1);
                break;

            case'd':
            Upper1.speed(-1);
            pc.printf("Motor down left\n");
            /*
                if(enable==1) {
                    Upper1.speed(0);
                    //printf("stop\n");
                } else if(enable==0) {
                    Upper1.speed(-1);
                    //printf("down left\n");
                }
                */
                break;

            case'l':
                pc.printf("Motor up right\n");
                Upper2.speed(1);
                break;

            case'k':
            Upper2.speed(-1);
             pc.printf("Motor down right\n");
            /*
           
                if(enable1==1) {
                    Upper2.speed(0);
                    //printf("stop\n");
                } else if(enable1==0) {
                    Upper2.speed(-1);
                    //printf("down right\n");
                }
                */
                break;

            case's':
                //printf("Motor stop\n");
                 pc.printf("Motor stop\n");
                Upper1.speed(0);
                Upper2.speed(0);
                break;

            case'w':
                j = (Ain1.read()*3.3);
                pc.printf("memory = %3.3f\n",j);
                memory.write(14,j);
                wait_ms(1);
                j1 = (Ain2.read()*3.3);
                pc.printf("memory = %3.3f\n",j1);
                memory.write(11,j1);
                wait_ms(1);
                break;
                
            case'e':

                memory.read(14,x);
                wait_ms(1);
                pc.printf("display = %3.3f\n",j);
                memory.read(11,y);
                wait_ms(1);
                pc.printf("diplay = %3.3f\n",j1);
                break;
        }
    }
}