#ifndef MBED_MOTOR_RE_H
#define MBED_MOTOR_RE_H

#include "mbed.h"
#include "motor_relay.h"

class MOTION_CONTROL
{
public:
    MOTION_CONTROL(PinName dirA, PinName dirB, PinName limitUp, PinName limitDown, PinName vr );

    int limit_motor(uint8_t dirction);
    int8_t position_control(uint16_t target);
    void calibration();

    //limit
    // open : '0'
    // shot : '1'
    int GetLimitUp(); 
    int GetLimitDown();

    void SetMargin(int16_t data);
    int16_t GetMargin();

    uint16_t GetMaxPosition();
    uint16_t GetMinPosition();
    void SetMaxPosition(uint16_t value);
    void SetMinPosition(uint16_t value);

    uint16_t GetAnalog();
    uint16_t GetPosition();

    void stop();

    void SetMode(uint8_t mode);
    uint8_t GetMode();
    
    void SetOffset(uint16_t value);
    uint16_t GetOffset();
    
    
private:

    uint16_t Scale(uint16_t data);

    MOTOR_RELAY motor;

    DigitalIn _limit_up;
    DigitalIn _limit_down;
    AnalogIn _position;

    int16_t error;
    int16_t MARGIN;

    uint16_t MAX_POSITION;
    uint16_t MIN_POSITION;

    const static uint16_t scale = 64;
    const static uint16_t LOOP = 100;
    
    uint8_t mode_limit;
    uint16_t OFFSET_MAX_POSITION;
    //float Kp;
    //float Ki;
    //float Kd;
    //float margin_pid;

};

#endif