//
//  iSerial.h ... Serial Driver with Interrupt Rec/Send
//
//  Copyright 2012  Yoji KURODA
//
//  2009.11.13 ... Originally written by Y.Kuroda for Renesas H83664
//  2012.08.31 ... Code convert for mbed in C++
//
#ifndef _ISERIAL_H
#define _ISERIAL_H

#include <string.h>
#include "RingBuffer.h"


class iSerial : public Serial {
  protected:

    PinName tx;
    PinName rx;
    const int txbufsize;
    const int rxbufsize;
    RingBuffer txbuf;
    RingBuffer rxbuf;
    char* str;

    void tx_handler(void);
    void rx_handler(void);
    void enable_uart_irq(void);
    void disable_uart_irq(void);

  public:

    enum TERMINL_CODES { CR=0x0D, LF=0x0A };

    iSerial(PinName _tx, PinName _rx, const char *_name=NULL, int _txbufsize=100, int _rxbufsize=100);
    virtual ~iSerial();
    
    short int putstr(const char* s);

    int readable(void);
    int getc(void);
    void putc(short ch);
    short int puts(const char* s);
    //void printf();
    char* printf(const char* format, ...);

    void flush(void);
};


#endif    /* _SCI_H */
