//#define ANDANTE_DEBUG

#include "string"
#include "BEAR_Protocol.h"

#include "Kinematic.h"

#define TIME_SYNC_COMMUNICATION 5 //unit ms

Serial pc(SERIAL_TX,SERIAL_RX);
Bear_Communicate bcom(PA_15,PB_7,1000000);
Kinematic Left(0,0),Right(0,0);

DigitalIn button(USER_BUTTON);

#define LEFT_SIDE  0x01
#define RIGHT_SIDE 0x02

Timer sync_communicate;

int16_t show_menu()
{
    int16_t option=9999;
    float temp[6];
    pc.printf("************Don't Forget to Save Data************\n");

    while(sync_communicate.read_ms() < TIME_SYNC_COMMUNICATION);
    sync_communicate.reset();
    bcom.getMotorPos(LEFT_SIDE,&temp[0],&temp[1]);
    pc.printf("*\t1) Motor Left Hip [%f]\t\t*\n",temp[0]);
    pc.printf("*\t2) Motor Left Knee [%f]\t\t*\n",temp[1]);

    while(sync_communicate.read_ms() < TIME_SYNC_COMMUNICATION);
    sync_communicate.reset();
    bcom.getMotorPos(RIGHT_SIDE,&temp[0],&temp[1]);
    pc.printf("*\t3) Motor Right Hip [%f]\t\t*\n",temp[0]);
    pc.printf("*\t4) Motor Right Knee [%f]\t\t*\n",temp[1]);

    while(sync_communicate.read_ms() < TIME_SYNC_COMMUNICATION);
    sync_communicate.reset();
    bcom.getUpMotorKpKiKd(LEFT_SIDE,&temp[0],&temp[1],&temp[2]);
    pc.printf("*\t5) Kp : Left Hip [%f]\t\t*\n",temp[0]);
    pc.printf("*\t6) Ki : Left Hip [%f]\t\t*\n",temp[1]);
    pc.printf("*\t7) Kd : Left Hip [%f]\t\t*\n",temp[2]);

    while(sync_communicate.read_ms() < TIME_SYNC_COMMUNICATION);
    sync_communicate.reset();
    bcom.getLowMotorKpKiKd(LEFT_SIDE,&temp[0],&temp[1],&temp[2]);
    pc.printf("*\t8) Kp : Left Knee [%f]\t\t*\n",temp[0]);
    pc.printf("*\t9) Ki : Left Knee [%f]\t\t*\n",temp[1]);
    pc.printf("*\t10) Kd : Left Knee [%f]\t\t*\n",temp[2]);

    while(sync_communicate.read_ms() < TIME_SYNC_COMMUNICATION);
    sync_communicate.reset();
    bcom.getUpMotorKpKiKd(RIGHT_SIDE,&temp[0],&temp[1],&temp[2]);
    pc.printf("*\t11) Kp : Right Hip [%f]\t\t*\n",temp[0]);
    pc.printf("*\t12) Ki : Right Hip [%f]\t\t*\n",temp[1]);
    pc.printf("*\t13) Kd : Right Hip [%f]\t\t*\n",temp[2]);

    while(sync_communicate.read_ms() < TIME_SYNC_COMMUNICATION);
    sync_communicate.reset();
    bcom.getLowMotorKpKiKd(RIGHT_SIDE,&temp[0],&temp[1],&temp[2]);
    pc.printf("*\t14) Kp : Right Knee [%f]\t\t*\n",temp[0]);
    pc.printf("*\t15) Ki : Right Knee [%f]\t\t*\n",temp[1]);
    pc.printf("*\t16) Kd : Right Knee [%f]\t\t*\n",temp[2]);

    while(sync_communicate.read_ms() < TIME_SYNC_COMMUNICATION);
    sync_communicate.reset();
    bcom.getUpMargin(LEFT_SIDE,&temp[0]);
    pc.printf("*\t17) Set Left Hip Margin [%f]\n",temp[0]);
    while(sync_communicate.read_ms() < TIME_SYNC_COMMUNICATION);
    sync_communicate.reset();
    bcom.getLowMargin(LEFT_SIDE,&temp[0]);
    pc.printf("*\t18) Set Left Knee Margin [%f]\n",temp[0]);
    while(sync_communicate.read_ms() < TIME_SYNC_COMMUNICATION);
    sync_communicate.reset();
    bcom.getUpMargin(RIGHT_SIDE,&temp[0]);
    pc.printf("*\t19) Set Right Hip Margin [%f]\n",temp[0]);
    while(sync_communicate.read_ms() < TIME_SYNC_COMMUNICATION);
    sync_communicate.reset();
    bcom.getLowMargin(RIGHT_SIDE,&temp[0]);
    pc.printf("*\t20) Set Right Knee Margin [%f]\n",temp[0]);


    while(sync_communicate.read_ms() < TIME_SYNC_COMMUNICATION);
    sync_communicate.reset();
    bcom.getUpLinkLength(LEFT_SIDE,&temp[0]);
    pc.printf("*\t21) Set Lenght of Left Link Hip [%f]\n",temp[0]);
    while(sync_communicate.read_ms() < TIME_SYNC_COMMUNICATION);
    sync_communicate.reset();
    bcom.getLowLinkLength(LEFT_SIDE,&temp[0]);
    pc.printf("*\t22) Set Lenght of Left Link Knee [%f]\n",temp[0]);

    while(sync_communicate.read_ms() < TIME_SYNC_COMMUNICATION);
    sync_communicate.reset();
    bcom.getUpLinkLength(RIGHT_SIDE,&temp[0]);
    pc.printf("*\t23) Set Lenght of Right Link Hip [%f]\n",temp[0]);
    while(sync_communicate.read_ms() < TIME_SYNC_COMMUNICATION);
    sync_communicate.reset();
    bcom.getLowLinkLength(RIGHT_SIDE,&temp[0]);
    pc.printf("*\t24) Set Lenght of Right Link Knee [%f]\n",temp[0]);

    while(sync_communicate.read_ms() < TIME_SYNC_COMMUNICATION);
    sync_communicate.reset();
    bcom.getOffset(LEFT_SIDE,&temp[0],&temp[1]);
    pc.printf("*\t25) Set Offset x[%f] y[%f]\n",temp[0],temp[1]);
    while(sync_communicate.read_ms() < TIME_SYNC_COMMUNICATION);
    sync_communicate.reset();
    bcom.getBodyWidth(LEFT_SIDE,&temp[0]);
    pc.printf("*\t26) Set Body Width [%f]\n",temp[0]);

    while(sync_communicate.read_ms() < TIME_SYNC_COMMUNICATION);
    sync_communicate.reset();
    bcom.getUpAngleRange(LEFT_SIDE,&temp[0],&temp[1]);
    bcom.getUpAngleRange(RIGHT_SIDE,&temp[2],&temp[3]);
    pc.printf("*\t27) Set Maximum Hip Angle Range \n");
    pc.printf("\tLeft Maximum Hip Angle Range [%f]\n",temp[0]);
    pc.printf("\tRight Maximum Hip Angle Range [%f]\n\n",temp[2]);

    pc.printf("*\t28) Set Minimum Hip Angle Range \n");
    pc.printf("\tLeft Minimum Hip Angle Range [%f]\n",temp[1]);
    pc.printf("\tRight Minimum Hip Angle Range [%f]\n\n",temp[3]);

    while(sync_communicate.read_ms() < TIME_SYNC_COMMUNICATION);
    sync_communicate.reset();
    bcom.getLowAngleRange(LEFT_SIDE,&temp[0],&temp[1]);
    bcom.getLowAngleRange(RIGHT_SIDE,&temp[2],&temp[3]);
    pc.printf("*\t29) Set Maximum Knee Angle Range \n");
    pc.printf("\tLeft Maximum Knee Angle Range [%f]\n",temp[0]);
    pc.printf("\tRight Maximum Knee Angle Range [%f]\n\n",temp[2]);

    pc.printf("*\t30) Set Minimum Knee Angle Range \n");
    pc.printf("\tLeft Minimum Knee Angle Range [%f]\n",temp[1]);
    pc.printf("\tRight Minimum Knee Angle Range [%f]\n\n",temp[3]);

    pc.printf("*\t40) Exit Program \t\t\t*\n");
    pc.printf("************Don't Forget to Save Data************\n");
    // Prompting user to enter an option according to menu
    pc.printf("Please select an option : ");


    pc.scanf("%d",&option);
    if(sync_communicate.read_ms() >0x7FFFFF00) {
        sync_communicate.reset();
    }
    pc.printf("\n");



    return option;
}

void SwMode()
{
    int option;
    float temp;
    float LH,LK,RH,RK;
    //float LLink[2],RLink[2];
    float LLink0,LLink1,RLink0,RLink1;
    struct max_ang {
        float Hip;
        float Knee;
    };
    struct min_ang {
        float Hip;
        float Knee;
    };
    max_ang Lmax,Lmin;
    min_ang Rmax,Rmin;
    Lmax.Knee = Lmax.Hip = Lmin.Knee = Lmin.Hip = Rmax.Knee = Rmax.Hip = Rmin.Knee = Rmin.Hip = 0;
    bool a,b,c,d;
    a = b = c = d = false;
    float temp_LH=0,temp_LK=0,temp_RH=0,temp_RK=0;
    do {
        //float buff;

        option = show_menu();


        if(option == 1)// Left Hip
            do {
                pc.printf("\nType 9999 to Exit to Main Menu\n");
                //Send Position to Motor
                pc.printf("Input Degree : \n");
                pc.scanf("%f",&temp);
                if(temp!=9999) {
                    LH = temp;
                    pc.printf("Move Left Hip Motor to %f Degree\n",LH);

                    bcom.setMotorPos(LEFT_SIDE,LH,temp_LK);
                    temp_LH = LH;

                    /********************Save Data*********************/
                } //else bcom.saveDataToEEPROM(LEFT_SIDE,MOTOR_UPPER_ANG);

            } while(temp != 9999);

        else if(option == 2) //Left Knee
            do {
                pc.printf("\nType 9999 to Exit to Main Menu\n");

                //Send Position to Motor
                pc.printf("Input Degree : \n");
                pc.scanf("%f",&temp);
                if(temp!=9999) {
                    LK = temp;
                    pc.printf("Move Left Knee Motor to %f Degree\n",LK);

                    bcom.setMotorPos(LEFT_SIDE,temp_LH,LK);
                    temp_LK = LK;


                    /********************Save Data*********************/
                } //else bcom.saveDataToEEPROM(LEFT_SIDE,MOTOR_LOWER_ANG);

            } while(temp != 9999);


        else if(option == 3) { //Right Hip
            do {
                pc.printf("\nType 9999 to Exit to Main Menu\n");

                //Send Position to Motor
                pc.printf("Input Degree : \n");
                pc.scanf("%f",&temp);
                if(temp!=9999) {
                    RH = temp;
                    pc.printf("Move Right Hip Motor to %f Degree\n",RH);

                    bcom.setMotorPos(RIGHT_SIDE,RH,temp_RK);
                    temp_RH = RH;


                    /********************Save Data*********************/
                } //else bcom.saveDataToEEPROM(RIGHT_SIDE,MOTOR_UPPER_ANG);

            } while(temp != 9999);

        } else if(option == 4) { //Right Knee
            do {
                pc.printf("\nType 9999 to Exit to Main Menu\n");

                //Send Position to Motor
                pc.printf("Input Degree : \n");
                pc.scanf("%f",&temp);

                if(temp != 9999) {
                    RK = temp;
                    pc.printf("Move Right Knee Motor to %f Degree\n",RK);

                    bcom.setMotorPos(RIGHT_SIDE,temp_RH,RK);
                    temp_RK = RK;


                    /********************Save Data*********************/
                } //else bcom.saveDataToEEPROM(RIGHT_SIDE,MOTOR_LOWER_ANG);

            } while(temp != 9999);

        } else if(option == 5) { //Left Hip
            do {
                pc.printf("\nType 9999 to Exit to Main Menu\n");
                pc.printf("\nInput Kp of Left Hip\n");
                pc.scanf("%f",&temp);

                if(temp != 9999) {
                    pc.printf("\nChange Kp of Left Hip to %f",temp);

                    bcom.setUpMotorKp(LEFT_SIDE,temp);
                } else bcom.saveDataToEEPROM(LEFT_SIDE,PID_UPPER_MOTOR);

            } while(temp != 9999);

        } else if(option == 6) { //Left Hip
            do {
                pc.printf("\nType 9999 to Exit to Main Menu\n");
                pc.printf("\nInput Ki of Left Hip\n");
                pc.scanf("%f",&temp);

                if(temp != 9999) {
                    pc.printf("\nChange Ki of Left Hip to %f",temp);

                    bcom.setUpMotorKi(LEFT_SIDE,temp);
                } else bcom.saveDataToEEPROM(LEFT_SIDE,PID_UPPER_MOTOR);

            } while(temp != 9999);

        } else if(option == 7) { //Left Hip
            do {
                pc.printf("\nType 9999 to Exit to Main Menu\n");
                pc.printf("\nInput Kd of Left Hip\n");
                pc.scanf("%f",&temp);

                if(temp != 9999) {
                    pc.printf("\nChange Kd of Left Hip to %f",temp);

                    bcom.setUpMotorKd(LEFT_SIDE,temp);
                } else bcom.saveDataToEEPROM(LEFT_SIDE,PID_UPPER_MOTOR);

            } while(temp != 9999);

        } else if(option == 8) { //Left Knee
            do {
                pc.printf("\nType 9999 to Exit to Main Menu\n");
                pc.printf("\nInput Kp of Left Knee\n");
                pc.scanf("%f",&temp);

                if(temp != 9999) {
                    pc.printf("\nChange Kp of Left Knee to %f",temp);

                    bcom.setLowMotorKp(LEFT_SIDE,temp);
                } else bcom.saveDataToEEPROM(LEFT_SIDE,PID_LOWER_MOTOR);

            } while(temp != 9999);

        } else if(option == 9) { //Left Knee
            do {
                pc.printf("\nType 9999 to Exit to Main Menu\n");
                pc.printf("\nInput Ki of Left Knee\n");
                pc.scanf("%f",&temp);

                if(temp != 9999) {
                    pc.printf("\nChange Ki of Left Knee to %f",temp);

                    bcom.setLowMotorKi(LEFT_SIDE,temp);
                } else bcom.saveDataToEEPROM(LEFT_SIDE,PID_LOWER_MOTOR);

            } while(temp != 9999);

        } else if(option == 10) { //Left Knee
            do {
                pc.printf("\nType 9999 to Exit to Main Menu\n");
                pc.printf("\nInput Kd of Left Knee\n");
                pc.scanf("%f",&temp);

                if(temp != 9999) {
                    pc.printf("\nChange Kd of Left Knee to %f",temp);

                    bcom.setLowMotorKd(LEFT_SIDE,temp);
                } else bcom.saveDataToEEPROM(LEFT_SIDE,PID_LOWER_MOTOR);

            } while(temp != 9999);


        } else if(option == 11) { //Right Hip
            do {
                pc.printf("\nType 9999 to Exit to Main Menu\n");
                pc.printf("\nInput Kp of Right Hip\n");
                pc.scanf("%f",&temp);

                if(temp != 9999) {
                    pc.printf("\nChange Kp of Right Hip to %f",temp);

                    bcom.setUpMotorKp(RIGHT_SIDE,temp);
                } else bcom.saveDataToEEPROM(RIGHT_SIDE,PID_UPPER_MOTOR);

            } while(temp != 9999);

        } else if(option == 12) { //Right Hip
            do {
                pc.printf("\nType 9999 to Exit to Main Menu\n");
                pc.printf("\nInput Ki of Right Hip\n");
                pc.scanf("%f",&temp);

                if(temp != 9999) {
                    pc.printf("\nChange Ki of Right Hip to %f",temp);

                    bcom.setUpMotorKi(RIGHT_SIDE,temp);
                } else bcom.saveDataToEEPROM(RIGHT_SIDE,PID_UPPER_MOTOR);

            } while(temp != 9999);

        } else if(option == 13) { //Right Hip
            do {
                pc.printf("\nType 9999 to Exit to Main Menu\n");
                pc.printf("\nInput Kd of Right Hip\n");
                pc.scanf("%f",&temp);

                if(temp != 9999) {
                    pc.printf("\nChange Kd of Right Hip to %f",temp);

                    bcom.setUpMotorKd(RIGHT_SIDE,temp);
                } else bcom.saveDataToEEPROM(RIGHT_SIDE,PID_UPPER_MOTOR);

            } while(temp != 9999);


        } else if(option == 14) { //Right Knee
            do {
                pc.printf("\nType 9999 to Exit to Main Menu\n");
                pc.printf("\nInput Kp of Right Knee\n");
                pc.scanf("%f",&temp);

                if(temp != 9999) {
                    pc.printf("\nChange Kp of Right Knee to %f",temp);

                    bcom.setLowMotorKp(RIGHT_SIDE,temp);
                } else bcom.saveDataToEEPROM(RIGHT_SIDE,PID_LOWER_MOTOR);

            } while(temp != 9999);

        } else if(option == 15) { //Right Knee
            do {
                pc.printf("\nType 9999 to Exit to Main Menu\n");
                pc.printf("\nInput Ki of Right Knee\n");
                pc.scanf("%f",&temp);

                if(temp != 9999) {
                    pc.printf("\nChange Ki of Right Knee to %f Degree\n",temp);

                    bcom.setLowMotorKi(RIGHT_SIDE,temp);
                } else bcom.saveDataToEEPROM(RIGHT_SIDE,PID_LOWER_MOTOR);

            } while(temp != 9999);

        } else if(option == 16) { //Right Knee
            do {
                pc.printf("\nType 9999 to Exit to Main Menu\n");
                pc.printf("\nInput Kd of Right Knee\n");
                pc.scanf("%f",&temp);

                if(temp != 9999) {
                    pc.printf("\nChange Kd of Right Knee to %f",temp);

                    bcom.setLowMotorKd(RIGHT_SIDE,temp);
                } else bcom.saveDataToEEPROM(RIGHT_SIDE,PID_LOWER_MOTOR);

            } while(temp != 9999);


        } else if(option == 17) { //Left Hip Margin
            pc.printf("\nType 9999 to Exit to Main Menu\n");
            pc.printf("Input Margin\n");
            pc.scanf("%f",&temp);

            if(temp != 9999) {
                pc.printf("\nChange Left Hip Margin to %f\n",temp);
                bcom.setUpMargin(LEFT_SIDE,temp);
            } //else
            bcom.saveDataToEEPROM(LEFT_SIDE,UP_MARGIN);
        }

        else if(option == 18) { //Left Knee Margin
            pc.printf("\nType 9999 to Exit to Main Menu\n");
            pc.printf("Input Margin\n");
            pc.scanf("%f",&temp);

            if(temp != 9999) {
                pc.printf("\nChange Left Knee Margin to %f\n",temp);
                bcom.setLowMargin(LEFT_SIDE,temp);
            } //else
            bcom.saveDataToEEPROM(LEFT_SIDE,LOW_MARGIN);
        }

        else if(option == 19) { //Right Hip Margin
            pc.printf("\nType 9999 to Exit to Main Menu\n");
            pc.printf("Input Margin\n");
            pc.scanf("%f",&temp);

            if(temp != 9999) {
                pc.printf("\nChange Right Hip Margin to %f\n",temp);
                bcom.setUpMargin(RIGHT_SIDE,temp);
            } //else
            bcom.saveDataToEEPROM(RIGHT_SIDE,UP_MARGIN);
        }

        else if(option == 20) { //Right Knee Margin
            pc.printf("\nType 9999 to Exit to Main Menu\n");
            pc.printf("Input Margin\n");
            pc.scanf("%f",&temp);

            if(temp != 9999) {
                pc.printf("\nChange Right Knee Margin to %f\n",temp);
                bcom.setLowMargin(RIGHT_SIDE,temp);
            } //else
            bcom.saveDataToEEPROM(RIGHT_SIDE,LOW_MARGIN);
        }

        else if(option == 21) { //Lenght of Left Link Hip
            pc.printf("\nType 9999 to Exit to Main Menu\n");
            pc.printf("Input Lenght of Left Link Hip\n");
            pc.scanf("%f",&temp);

            if(temp != 9999) {
                pc.printf("\nLenght of Left Link Hip = %f\n",temp);
                LLink0 = temp;
                a = true;
                bcom.setUpLinkLength(LEFT_SIDE,temp);
            } //else
            bcom.saveDataToEEPROM(LEFT_SIDE,UP_LINK_LENGTH);
        }

        else if(option == 22) { //Lenght of Left Link Knee
            pc.printf("\nType 9999 to Exit to Main Menu\n");
            pc.printf("Input Lenght of Left Link Knee\n");
            pc.scanf("%f",&temp);

            if(temp != 9999) {
                pc.printf("\nLenght of Left Link Knee = %f\n",temp);
                LLink1 = temp;
                b = true;
                bcom.setLowLinkLength(LEFT_SIDE,temp);
            } //else
            bcom.saveDataToEEPROM(LEFT_SIDE,LOW_LINK_LENGTH);
        }

        else if(option == 23) { //Lenght of Right Link Hip
            pc.printf("\nType 9999 to Exit to Main Menu\n");
            pc.printf("Input Lenght of Right Link Hip\n");
            pc.scanf("%f",&temp);

            if(temp != 9999) {
                pc.printf("\nLenght of Right Link Hip = %f\n",temp);
                RLink0 = temp;
                c = true;
                bcom.setUpLinkLength(RIGHT_SIDE,temp);
            } //else
            bcom.saveDataToEEPROM(RIGHT_SIDE,UP_LINK_LENGTH);
        }

        else if(option == 24) { //Lenght of Right Link Knee
            pc.printf("\nType 9999 to Exit to Main Menu\n");
            pc.printf("Input Lenght of Right Link Knee\n");
            pc.scanf("%f",&temp);

            if(temp != 9999) {
                pc.printf("\nLenght of Right Link Knee = %f\n",temp);
                RLink1 = temp;
                d = true;
                bcom.setLowLinkLength(RIGHT_SIDE,temp);
            } //else
            bcom.saveDataToEEPROM(RIGHT_SIDE,LOW_LINK_LENGTH);
        }

        else if(option == 25) { //Offset
            if(a == true && b == true && c == true && d == true) {
                float LHipAngle,LKneeAngle;
                float RHipAngle,RKneeAngle;

                bcom.getMotorPos(LEFT_SIDE,&LHipAngle,&LKneeAngle);
                wait_ms(90);
                bcom.getMotorPos(RIGHT_SIDE,&RHipAngle,&RKneeAngle);
                wait_ms(90);

                Left.set_Link_Hip(LLink0);
                Left.set_Link_Knee(LLink1);
                Left.set_Zeta_Hip(LHipAngle);
                Left.set_Zeta_Knee(LKneeAngle);

                Right.set_Link_Hip(RLink0);
                Right.set_Link_Knee(RLink1);
                Right.set_Zeta_Hip(RHipAngle);
                Right.set_Zeta_Knee(RKneeAngle);

                Left.ForwardKinematicCalculation();
                Right.ForwardKinematicCalculation();

                float offset_Y,offset_Z;
                float y1,y2,z1,z2;
                y1 = Left.get_Position_Y();
                y2 = Right.get_Position_Y();
                z1 = Left.get_Position_Z();
                z2 = Right.get_Position_Z();
                offset_Y = y1-y2;
                offset_Z = z1-z2;

                bcom.setOffset(LEFT_SIDE,offset_Y,offset_Z);

                bcom.saveDataToEEPROM(LEFT_SIDE,OFFSET);

            } else {
                pc.printf("\nYou have to do choice 21-23 first\n\n");
                wait(1);
            }
        }

        else if(option == 26) { //setBodyWidth
            pc.printf("\nType 9999 to Exit to Main Menu\n");
            pc.printf("Input Body Width\n");
            pc.scanf("%f",&temp);
            pc.printf("\nBody Lenght = %f\n",temp);
            bcom.setBodyWidth(LEFT_SIDE,temp);
            bcom.saveDataToEEPROM(LEFT_SIDE,BODY_WIDTH);
        }

        else if(option == 27) { //Set Maximum Hip Angle Range
            do {
                pc.printf("\nType 9999 to Exit to Main Menu\n");
                pc.printf("1) Left Side\n");
                pc.printf("2) Right Side\n");
                pc.scanf("%f",&temp);

                if(temp==1) { //Left
                    pc.printf("Input Maximum Hip Angle Range of Left Side\n");
                    pc.scanf("%f",&temp);

                    if(temp != 9999) {
                        pc.printf("\nMaximum Hip Angle Range of Left Side = %f\n",temp);
                        bcom.setUpAngleRange(LEFT_SIDE,temp,Lmin.Hip);
                        Lmax.Hip = temp;
                    } //else
                    bcom.saveDataToEEPROM(LEFT_SIDE,ANGLE_RANGE_UP);

                } else if(temp==2) { //Right
                    pc.printf("Input Maximum Hip Angle Range of Right Side\n");
                    pc.scanf("%f",&temp);

                    if(temp != 9999) {
                        pc.printf("\nMaximum Hip Angle Range of Right Side = %f\n",temp);
                        bcom.setUpAngleRange(RIGHT_SIDE,temp,Rmin.Hip);
                        Rmax.Hip = temp;
                    } //else
                    bcom.saveDataToEEPROM(RIGHT_SIDE,ANGLE_RANGE_UP);
                }
            } while(temp!=9999);
        }

        else if(option == 28) { //Set Minumum Hip Angle Range
            do {
                pc.printf("\nType 9999 to Exit to Main Menu\n");
                pc.printf("1) Left Side\n");
                pc.printf("2) Right Side\n");
                pc.scanf("%f",&temp);

                if(temp==1) { //Left
                    pc.printf("Input Minumum Hip Angle Range of Left Side\n");
                    pc.scanf("%f",&temp);

                    if(temp != 9999) {
                        pc.printf("\nMinumum Hip Angle Range of Left Side = %f\n",temp);
                        bcom.setUpAngleRange(LEFT_SIDE,Lmax.Hip,temp);
                        Lmin.Hip = temp;
                    } //else
                    bcom.saveDataToEEPROM(LEFT_SIDE,ANGLE_RANGE_UP);

                } else if(temp==2) { //Right
                    pc.printf("Input Minumum Hip Angle Range of Right Side\n");
                    pc.scanf("%f",&temp);

                    if(temp != 9999) {
                        pc.printf("\nMinumum Hip Angle Range of Right Side = %f\n",temp);
                        bcom.setUpAngleRange(RIGHT_SIDE,Rmax.Hip,temp);
                        Rmin.Hip = temp;
                    } //else
                    bcom.saveDataToEEPROM(RIGHT_SIDE,ANGLE_RANGE_UP);
                }
            } while(temp!=9999);
        }


        else if(option == 29) { //Set Maximum Knee Angle Range
            do {
                pc.printf("\nType 9999 to Exit to Main Menu\n");
                pc.printf("1) Left Side\n");
                pc.printf("2) Right Side\n");
                pc.scanf("%f",&temp);

                if(temp==1) { //Left
                    pc.printf("Input Maximum Knee Angle Range of Left Side\n");
                    pc.scanf("%f",&temp);

                    if(temp != 9999) {
                        pc.printf("\nMaximum Knee Angle Range of Left Side = %f\n",temp);
                        bcom.setLowAngleRange(LEFT_SIDE,temp,Lmin.Knee);
                        Lmax.Knee = temp;
                    } //else
                    bcom.saveDataToEEPROM(LEFT_SIDE,ANGLE_RANGE_LOW);

                } else if(temp==2) { //Right
                    pc.printf("Input Maximum Knee Angle Range of Right Side\n");
                    pc.scanf("%f",&temp);

                    if(temp != 9999) {
                        pc.printf("\nMaximum Knee Angle Range of Right Side = %f\n",temp);
                        bcom.setLowAngleRange(RIGHT_SIDE,temp,Rmin.Knee);
                        Rmax.Knee = temp;
                    } //else
                    bcom.saveDataToEEPROM(RIGHT_SIDE,ANGLE_RANGE_LOW);
                }
            } while(temp!=9999);
        }

        else if(option == 30) { //Set Minumum Knee Angle Range
            do {
                pc.printf("\nType 9999 to Exit to Main Menu\n");
                pc.printf("1) Left Side\n");
                pc.printf("2) Right Side\n");
                pc.scanf("%f",&temp);

                if(temp==1) { //Left
                    pc.printf("Input Minumum Knee Angle Range of Left Side\n");
                    pc.scanf("%f",&temp);

                    if(temp != 9999) {
                        pc.printf("\nMinumum Knee Angle Range of Left Side = %f\n",temp);
                        bcom.setLowAngleRange(LEFT_SIDE,Lmax.Knee,temp);
                        Lmin.Knee = temp;
                    } //else
                    bcom.saveDataToEEPROM(LEFT_SIDE,ANGLE_RANGE_LOW);

                } else if(temp==2) { //Right
                    pc.printf("Input Minumum Knee Angle Range of Right Side\n");
                    pc.scanf("%f",&temp);

                    if(temp != 9999) {
                        pc.printf("\nMinumum Knee Angle Range of Right Side = %f\n",temp);
                        bcom.setLowAngleRange(RIGHT_SIDE,Rmax.Knee,temp);
                        Rmin.Knee = temp;
                    } //else
                    bcom.saveDataToEEPROM(RIGHT_SIDE,ANGLE_RANGE_LOW);
                }
            } while(temp!=9999);
        }






        else if(option == 40) {
            pc.printf("Are You Sure ?\n");
            pc.printf("\n1) Yes\n");
            pc.printf("2) No\n");

            pc.scanf("%d",&option);
            if(option==1) {
                option = 40;
                pc.printf("Please Push Button Restart\n");
            } else pc.printf("Return to Main Menu\n");

        }


        else { // if user has entered invalid choice
            pc.printf("\nInvalid Option entered\n");
        }
    } while(option != 40);

}



int main()
{
    Timer counterUP;
    Timer counterLOW;

    char state[2];
    float temp[2];
    pc.baud(115200);
    pc.printf("Start\n");

    sync_communicate.start();

    if(!button) {
        while(!button);
        SwMode();
    }
    sync_communicate.stop();

    counterUP.start();
    counterLOW.start();

    state[0] =0;
    state[1] =0;

    temp[0] =20;
    temp[1] =5;

    while(1) {

        if(counterUP.read_ms() > 1400) {
            if(state[0] ==0) {
                temp[0] = 20;
                state[0]=1;
            } else {
                temp[0] = 50;
                state[0]=0;
            }
            counterUP.reset();

        }

        if(counterLOW.read_ms() > 700) {
            if(state[1] ==0) {
                temp[1] = 5;
                state[1]=1;
            } else {
                temp[1] = 90;
                state[1]=0;
            }

            counterLOW.reset();

        }


        bcom.setMotorPos(LEFT_SIDE,temp[0],temp[1]);
        bcom.setMotorPos(RIGHT_SIDE,temp[0],temp[1]);

    }
}



/*int main()
{
    pc.baud(105200);
    int num;
    do {
        //float num;
        //Float number --> Working
        pc.printf("Start\n");
        pc.scanf("%d",&num);
        pc.printf("temp : %d\n",num);
        if( num == 15 )
            pc.printf("Yes\n");
        pc.printf("End\n");
    } while(num!=20);
}*/