#ifndef MPU9250_H
#define MPU9250_H

#include "mbed.h"
#include "math.h"
#include "register.h"


static DigitalOut myled(LED1);


class MPU9250
{

protected:

public:
    enum Ascale {
        AFS_2G = 0,
        AFS_4G,
        AFS_8G,
        AFS_16G
    };

    enum Gscale {
        GFS_250DPS = 0,
        GFS_500DPS,
        GFS_1000DPS,
        GFS_2000DPS
    };

    enum Mscale {
        MFS_14BITS = 0, // 0.6 mG per LSB
        MFS_16BITS      // 0.15 mG per LSB
    };

    MPU9250(PinName sda, PinName scl, PinName tx, PinName rx, int address);
    
    ~MPU9250() {}

    Serial pc;
    I2C i2c;
    void writeByte(uint8_t address, uint8_t subAddress, uint8_t data);
    char readByte(uint8_t address, uint8_t subAddress);
    void readBytes(uint8_t address, uint8_t subAddress, uint8_t count, uint8_t * dest) ;

    void initMPU9250();
    void calibrateMPU9250();

    void setMres();
    void setGres();
    void setAres();
    
    void getMres();
    void getGres();
    void getAres();

    void AccelXYZCal();
    void GyroXYZCal();
    void MagXYZCal();

    void MagCal();

    void readAccelData();
    void readGyroData();
    void readMagData();
    void readTempData();

    void resetMPU9250();
    void initAK8963();
    void MPU9250SelfTest();
    
    void Start();
    void ReadRawAccGyroMag();
    
    float ax, ay, az, gx, gy, gz, mx, my, mz; // variables to hold latest sensor data values
    

protected:
    float temperature;
    uint8_t whoami;

private:
    uint8_t MPU9250_ADDRESS;

    int16_t accelCount[3];  // Stores the 16-bit signed accelerometer sensor output
    int16_t gyroCount[3];   // Stores the 16-bit signed gyro sensor output
    int16_t magCount[3];    // Stores the 16-bit signed magnetometer sensor output
    float magCalibration[3], magbias[3];  // Factory mag calibration and mag bias
    float gyroBias[3], accelBias[3]; // Bias corrections for gyro and accelerometer
    //int16_t tempCount;   // Stores the real internal chip temperature in degrees Celsius
    float SelfTest[6];



    //MagCal
    float xmax,xmin;
    float ymax,ymin;
    float zmax,zmin;
    bool change;

    uint8_t Ascale;     // AFS_2G, AFS_4G, AFS_8G, AFS_16G
    uint8_t Gscale; // GFS_250DPS, GFS_500DPS, GFS_1000DPS, GFS_2000DPS
    uint8_t Mscale; // MFS_14BITS or MFS_16BITS, 14-bit or 16-bit magnetometer resolution
    uint8_t Mmode;        // Either 8 Hz 0x02) or 100 Hz (0x06) magnetometer data ODR
    float aRes, gRes, mRes;      // scale resolutions per LSB for the sensors

};
#endif