#ifndef _KINEMATIC_H_
#define _KINEMATIC_H_

#include "mbed.h"

class Kinematic
{
private:
    float Link_Hip;    //centimeter
    float Link_Knee;   //centimeter
    float Zeta_Hip;    //degree
    float Zeta_Knee;   //degree
    float Position_Y;  //centimeter
    float Position_Z;  //centimeter
    
    //float offset_y;
    //float offset_z;
    
    float zeta_knee_range_max;
    float zeta_knee_range_min;
    float zeta_hip_range_max;
    float zeta_hip_range_min;
    
    
public:
    Serial test;
    Kinematic(float, float);
    Kinematic(char, float, float, float, float);
    
    float get_Link_Hip() {
        return Link_Hip;
    }
    float get_Link_Knee() {
        return Link_Knee;
    }
    float get_Zeta_Hip() {
        return Zeta_Hip;
    }
    float get_Zeta_Knee() {
        return Zeta_Knee;
    }
    float get_Position_Y() {
        return Position_Y;
    }
    float get_Position_Z() {
        return Position_Z;
    }
    /*
    float get_offset_y() {
        return offset_y;
    }
    float get_offset_z() {
        return offset_z;
    }
*/
    void set_Link_Hip(float);
    void set_Link_Knee(float);
    void set_Zeta_Hip(float);
    void set_Zeta_Knee(float);
    void set_Position_Y(float);
    void set_Position_Z(float);
    void set_zeta_knee_range(float max,float min);
    void set_zeta_hip_range(float max,float min);
    
    //void set_offset_YZ(float,float);
    //void SumPositionWithOffset();

    void ForwardKinematicCalculation();
    void InverseKinematicCalculation();

    void show_z();
};

#endif