#include "mbed.h"
#include "Command.h"
#include "communication.h"

#define SERIAL_DEBUG
#define RS485_DELAY 90
#define RS485_DIRC PA_14



class Bear_Communicate
{
private:
    COMMUNICATION *com;

public:
    Bear_Communicate(PinName,PinName,int);
    void FloatSep(float,uint8_t*,uint8_t*);
// Set Command
    uint8_t setID(uint8_t,uint8_t);
    uint8_t setMotorPos(uint8_t,float,float);
    uint8_t setUpMotorKp(uint8_t,float);
    uint8_t setLowMotorKp(uint8_t,float);
    uint8_t setUpMotorKi(uint8_t,float);
    uint8_t setLowMotorKi(uint8_t,float);
    uint8_t setUpMotorKd(uint8_t,float);
    uint8_t setLowMotorKd(uint8_t,float);
    //EEPROM
    uint8_t setUpMargin(uint8_t,float);
    uint8_t setLowMargin(uint8_t,float);
    uint8_t setHeight(uint8_t,float);
    uint8_t setWheelPos(uint8_t,float);
    uint8_t setMagData(uint8_t,float,float,float,float,float,float);
    uint8_t setOffset(uint8_t,float,float);
    uint8_t setBodyWidth(uint8_t,float);
    uint8_t setUpAngleRange(uint8_t,float,float);
    uint8_t setLowAngleRange(uint8_t,float,float);
    uint8_t setUpLinkLength(uint8_t,float);
    uint8_t setLowLinkLength(uint8_t,float);

// get Command
    uint8_t getMotorPos(uint8_t,float*,float*);
    uint8_t getUpMotorKpKiKd(uint8_t,float*,float*,float*);
    uint8_t getLowMotorKpKiKd(uint8_t,float*,float*,float*);
    //EEPROM
    uint8_t getUpMargin(uint8_t,float*);
    uint8_t getLowMargin(uint8_t,float*);
    uint8_t getHeight(uint8_t,float*);
    uint8_t getWheelPos(uint8_t,float*);
    uint8_t getMagData(uint8_t,float*,float*,float*,float*,float*,float*);
    uint8_t getOffset(uint8_t,float*,float*);
    uint8_t getBodyWidth(uint8_t,float*);
    uint8_t getUpAngleRange(uint8_t,float*,float*);
    uint8_t getLowAngleRange(uint8_t,float*,float*);
    uint8_t getUpLinkLength(uint8_t,float*);
    uint8_t getLowLinkLength(uint8_t,float*);
    
    
    uint8_t saveDataToEEPROM(uint8_t,uint8_t);
};