/***********************************
name:   BERTL_2014_LED D2 blink via I2C 
modyfied by ENE@bulme.at
description:
  Alle LED sind INVERS dh 0 = EIN;  1 = AUS;
  mit LED D2 blinken
*/  
  
#include "mbed.h" 
/*** Portkonfiguration ***/
Serial pc(USBTX, USBRX); // tx, rx
I2C i2c(p28,p27);

/*** Funktionsdefinitionen ***/

const int addr = 0x40;  // I2C-Adresse PCA9555
char cmd[3];            // Datenarray für I2C

/*** Funktionen ***/
int main()
{
/*** I2C Konfigurationen ***/
        i2c.frequency(40000);  // I2C Frequenz 40kHz
        cmd[0] = 0x06;
        cmd[1] = 0x00;           
        i2c.write(addr, cmd, 2); // Define Port0 = Out


/*** Hauptprogramm - Endlosschleife ***/
    while(1) 
    {
        cmd[0] = 0x02;
        cmd[1] = 0xFD;           // D2 ON ->   1111 1101   
        i2c.write(addr, cmd, 2); // Def. Port0 = 0xFD
        wait(0.5);
        
        //cmd[0] = 0x02;         // nicht mehr nötig, da bereits definiert !
                                 // und nicht verändert
        cmd[1] = 0xFF;           // Alle LED OFF ->  1111 1111 
        i2c.write(addr, cmd, 2); // Def. Port0 = 0xFF
        wait(0.5);
                  
    }
}
