/***********************************
name:   BERTL14_UART
author: Wolfgang Raimann modified for dummies by ENE
description:
    Schreibt nach einem Reset "Welcome to BERTL14". Danach gibt er die eingegeben Zeichen zurück.
    Zusätzlich werden Großbuchstaben in Kleinbuchstaben und umgekehrt umgewandelt.
    Einzustellen am PC: 9600 Baud; 8 Databit; 1 Stopp Bit; None Parity
    
HOW to DO it ! by ENE
1) Installiere am PC die Software "Tera Term" oä
2) Verbinde den PC mit dem UART Port des Bertl. 
   (Dazu must du das USB Kable von U11 auf UART UMSTECKEN !)
2) rufe "Tera Term" auf.
3) aktiviere "SERIELL" 
4) Stelle das PORT auf  "USB Serial Port"
   Wenn nicht da, einige Male den Res am Bertl drücken!
5) OK -> bringt einen schwarzen Bildschirm
6) Am Bertl die RES Taste drücken->      
   bringt am Bildschirm "Welcome to BERTL14"
   Wenn es nicht geht drücke:  Datei - Neue Verbindung  und "USB Serial Port"
7) Was nun auf der Tastatur gedrückt wird kommt zum Bertl,
   und zurück zum PC, wo es angezeigt wird !     
***********************************/
# include "mbed.h"
Serial pc(USBTX, USBRX);
 
int main() {
    char readChar = 0;
    pc.printf("Welcome to BERTL14\n\r");
    while(1) {
        readChar = pc.getc();
        if(readChar >= 65 && readChar <= 90){ // Großbuchstaben in Kleinbuchstaben umwandeln
            pc.putc(readChar + 32);
        } else if(readChar >= 97 && readChar <= 122){ // Kleinbuchstaben in Großbuchstaben umwandeln
            pc.putc(readChar - 32);
        } else {    // Sonst schicke was gekommen ist
            pc.putc(readChar);
        }
    }
}
