/***********************************
name:   config.h    v0.4
author: PE HTL BULME
email:  pe@bulme.at
description:
    Constants and wiring for ur_Bertl
    HC-SR04 ultrasonic sensor added
      
***********************************/
#ifndef _FOO_H
#define _FOO_H

#include "mbed.h"
#include "hcsr04.h"

#define DEBUG 0

const int BTN_FLL = 0x80;   // button front left outer
const int BTN_FL  = 0x04;   // button front left
const int BTN_FM  = 0x01;   // button front middle
const int BTN_FR  = 0x08;   // button front right 
const int BTN_FRR = 0x40;   // button front right outer
const int BTN_BL = 0x10;    // button back left
const int BTN_BM = 0x02;    // button back middle
const int BTN_BR = 0x20;    // button back right

const int LED_FL1 = 0x01;   // front LED white 
const int LED_FL2 = 0x02;   // front LED yellow
const int LED_FR1 = 0x04;   // front LED white
const int LED_FR2 = 0x08;   // front LED yellow
const int LED_ALL_FRONT = 0x0F;

const int LED_BL1 = 0x20;   // yellow LED back left outer
const int LED_BL2 = 0x10;   // red LED back left inner
const int LED_BR1 = 0x80;   // yellow LED back right outer
const int LED_BR2 = 0x40;   // red LED back right inner
const int LED_ALL_BACK = 0xF0;
const int LED_ALL = 0xFF;

const int addr = 0x40;      // I2C-address PCA9555

Serial pc(USBTX, USBRX);    // tx, rx  

DigitalOut LED_D10(P1_8);    // wiring LED D10 to D13 
DigitalOut LED_D11(P1_9);    
DigitalOut LED_D12(P1_10);   
DigitalOut LED_D13(P1_11);   

DigitalOut MotorL_EN(p34);  // wiring motor left
DigitalOut MotorL_FORWARD(P1_1);    // changed for Bertl 307
DigitalOut MotorL_REVERSE(P1_0);

DigitalOut MotorR_EN(p36);  // wiring motor right
DigitalOut MotorR_FORWARD(P1_3);    
DigitalOut MotorR_REVERSE(P1_4);

I2C i2c(p28,p27);   
BusIn linesensor(p18, p16, p19, p17);  
DigitalIn SensorL(P1_12);    // motor sensor left
DigitalIn SensorR(P1_13);    // motor sensor right
HCSR04  usensor(p21,p22);    // HC-SR04 ultrasonic sensor

PwmOut mg1(P1_15);           //PWM Ausgang zum Motor Links
PwmOut mg2(P0_21);           //PWM Ausgang zum Motor Rechts
const int PERIOD = 20;
const int SPEED = 3;

#if defined(DEBUG) && DEBUG > 0
 #define DEBUG_PRINT(fmt, args...) fprintf(stderr, "DEBUG: %s:%d:%s(): " fmt, \
    __FILE__, __LINE__, __func__, ##args)
#else
 #define DEBUG_PRINT(fmt, args...) /* Don't do anything in release builds */
#endif

#endif