#include "mbed.h"

#include "LCD.h"
#define busy_mask 0x8000


LCD::LCD(PinName RS, PinName E, PinName d4, PinName d5,
                 PinName d6, PinName d7) : _RS(RS),
        _E(E), _DBUS(d4, d5, d6, d7) {

    _E  = 0;
    _RS = 0;            // command mode

    wait(0.015);        // Wait 15ms to ensure powered up

    // send "Display Settings" 3 times (Only top nibble of 0x30 as we've got 4-bit bus)

    wait(0.015);        // Wait 15ms to ensure powered up

    for (int i=0; i<3; i++) {
        DATA(0x30, CMD);
        wait(0.00164);  // this command takes 1.64ms, so wait for it
    }
    DATA(0x02, CMD);     // 4-bit mode
    wait(0.000040f);    // most instructions take 40us

    DATA(0x28,CMD); // Function set 001 BW N F - -
    DATA(0x0C,CMD);
    DATA(0x06,CMD);  // Cursor Direction and Display Shift : 0000 01 CD S (CD 0-left, 1-right S(hift) 0-no, 1-yes
    Clear();
    DATA(0x01,CMD); // cls, and set cursor to 0
    wait(0.00164f);     // This command takes 1.64 ms
    Write("Constructed");
}




/*int main(){
     //(PF_13, PE_9, PF_14, PF_15)
     //(PF_15, PF_14, PE_9,PF_13)
     LCD_DBUS = new BusInOut(PF_13, PE_9, PF_14, PF_15) ;
     LCD_Init();
     while(1){
     write_string("Hi");
     wait(0.1);
     }
    }
*/
// Initialise LCD Pins //
/*void LCD_Init(void){                                        
        LCD_E = 0;;          //clear enable
        LCD_RW = 0;                 // write
        LCD_RS = 0;         // command

        wait_ms(3);           //delay for LCD to initialise.

        LCD_DATA(0x28,CMD);     //set to 4 bit interface, 2 line and 5*8 font
        LCD_DATA(0x0f,CMD);     //cursor on, cursor position blink
        LCD_DATA(0x10,CMD);
        LCD_CLR;                //clear display
        LCD_DATA(0x06,CMD);     //move cursor right after write
        LCD_HOME;                   //return home

    LCD_E  = 1;
    LCD_RS = 0;            // command mode
    LCD_RW = 0;
    wait(0.015);        // Wait 15ms to ensure powered up

    for (int i=0; i<3; i++) {
        LCD_DATA(0x03, TXT);
        wait(0.00164);  // this command takes 1.64ms, so wait for it
    }
    LCD_DATA(0x02, TXT);     // 4-bit mode
    wait(0.000040f);    // most instructions take 40us

    LCD_DATA(0x28,CMD); // Function set 001 BW N F - -
    LCD_DATA(0x0C,CMD);
    LCD_DATA(0x06,CMD);  // Cursor Direction and Display Shift : 0000 01 CD S (CD 0-left, 1-right S(hift) 0-no, 1-yes
    LCD_DATA(0x01,CMD); // cls, and set cursor to 0
    wait(0.00164f);     // This command takes 1.64 ms
}*/
/*---------------------------------------------------------------------*/
void LCD::Clear(void){
    DATA(CLEAR,CMD);
    }
    
void LCD::RowSelect(int row){
    switch(row){
        case 0:
            DATA(LINE1,CMD); 
            break;
        case 1:
            DATA(LINE2,CMD); 
            break;
        case 2:
            DATA(LINE3,CMD);
            break;
        case 3:
            DATA(LINE4,CMD);
            break;
        default:
            DATA(LINE1,CMD);
            break;
        }
    }
    
void LCD::Busy(void)
{
        wait_ms(1);
}
/*---------------------------------------------------------------------*/
void LCD::DATA(char data,char type){

        Busy();                  //TEST LCD FOR BUSY 
        
        _DBUS = (data>>4);

        wait(0.00040f); // most instructions take 40us
    
        if(type == CMD)
        {
            _RS = 0;            //COMMAND MODE
        } 
        else 
        {
            _RS = 1;            //CHARACTER/DATA MODE
        }
        wait(0.00040f);

        _E = 1;                 //ENABLE LCD DATA LINE
        wait(0.00040f);         // most instructions take 40us
        _E = 0;                 //DISABLE LCD DATA LINE
            
        _DBUS = 0;
      
        _DBUS = (data);
        
        _E = 1;                 //ENABLE LCD DATA LINE
        wait(0.00040f);         // most instructions take 40us
        _E = 0;                 //DISABLE LCD DATA LINE
}
/*---------------------------------------------------------------------*/
void LCD::Write(char text[80]){   
    int i = 0;
      
    
    while((text[i] != 0))
    {
        
        char character = text[i];
        DATA (character,TXT);      // Write text "a" to the LCD
        
        i++;
    }
}
