#include "mbed.h"
#include "main.h"
#include "stdio.h"

LCD  lcd(PD_15, PF_12, PF_13, PE_9, PF_14, PF_15); 
BMP280 Sensor(D14, D15);

//Define Functions
void PrintLCD ();
void Rx_interrupt();
void serialCMD();
void sensorRead();
void readISR();
void circBuff();

/* LOCKS */ 
Mutex DataBuffer;
Mutex sensorData;

/* THREADS */
Thread _PrintLCD, _serialCMD, _circBuff;
Thread _sensorRead (osPriorityRealtime); //sensorData Thread


/* GLOBAL DATA */
volatile float LDR = 0;
volatile double PRES = 0;
volatile double TEMP = 0;

Ticker read;

/* INTERRUPTS */

/*--------------------------------MAIN--------------------------------*/
int main() {
    
    pc.baud(9600);
    pc.attach(&Rx_interrupt, Serial::RxIrq);
    POST();
    
    _serialCMD.start(serialCMD);
    _PrintLCD.start(PrintLCD);
    _sensorRead.start(sensorRead);
    _circBuff.start(circBuff);
    
    read.attach(readISR, SAMPLING_PERIOD);
    
    
    while (1) {}
    }
/*--------------------------------------------------------------------*/
void circBuff () {
    
    while(1) { 
            Thread::signal_wait(DATA_READY); // wait for signal from sensorRead
            
            //Lock data buffer
            DataBuffer.lock();
            
            //Format samples, send to FIFO buffer head
            memset(data_buffer[sample_h],NULL,64);
            time( &raw_time );
            sample_epoch = localtime( &raw_time );
            char sample_time[20];
            strftime(sample_time,20,"%d/%m/%Y %X",sample_epoch);
            
            sensorData.lock(); //lock critical section
            sprintf(data_buffer[sample_h],"%s, %2.2f, %4.2f, %.4f\n\r", sample_time, TEMP, PRES, LDR);
            sensorData.unlock(); //unlock critical section
            
            memset(sample_time,NULL,20);
            
            //Set seperate FIFO head and tail for printing data
            data_h = sample_h;
            data_t = sample_t;
            
            //Move sample FIFO buffer head to next row in buffer
            sample_h++;
            //Check sample FIFO buffer head
            if(sample_h >= MAX_SAMPLES){
                sample_h = 0;
            }
            //Check sample FIFO buffer tail
            if(sample_t == sample_h){
                sample_t++;
                if(sample_t >= (MAX_SAMPLES)){
                    sample_t = 0;
                }
            }
            //Unlock data buffer
            DataBuffer.unlock();
    }
}

/*---------------------Read Sensors ---------------------------*/

void readISR () { // Ticker interrupt defined in main
    
    _sensorRead.signal_set(SENSOR_UPDATE);
}
    
void sensorRead () {
    
    while (1) {
        
        sensorData.lock(); // Entering Critial Section
    
        // Store Data in global Variables
        LDR = LDR_In.read();
        TEMP = Sensor.getTemperature();
        PRES = Sensor.getPressure();
        
        sensorData.unlock(); // Exiting Critical Section
    
        Green_int = !Green_int; // debugging
            
        //Read sensors, send to mail-queue
        mail_t *mail = mail_box.alloc();
        mail->LDR_Value = LDR; 
        mail->temp_Value = TEMP;
        mail->press_Value = PRES;
        mail_box.put(mail);
        
        _circBuff.signal_set(DATA_READY);  // Set signal to buffer to store updated values
        Thread::signal_wait(SENSOR_UPDATE); // Wait for the Timer interrupt
    }
}
    

/*--------------------------------LCD---------------------------------*/
void PrintLCD () {
    
    int i = 0;
    while(1){
        char lightString[16];
        char tempString[16];
        char pressString[16];

        lcd.Clear();
        lcd.RowSelect(0);
         
        switch (i){
            case 0:{
                osEvent evt = mail_box.get();
        
                if (evt.status == osEventMail) {
                    mail_t *mail = (mail_t*)evt.value.p;
            
                    sprintf(lightString,"%.4f", mail->LDR_Value);
                    sprintf(tempString,"%2.2f", mail->temp_Value);
                    sprintf(pressString,"%4.2f", mail->press_Value);    
                
                    mail_box.free(mail);
                }
               
                lcd.Write("Light Level:");
                lcd.RowSelect(1);
                lcd.Write(lightString);
                i++;                
            break;
            }
            case 1:
                lcd.Write("Temperature:");
                lcd.RowSelect(1);
                lcd.Write(tempString);
                i++;
            break;
        
            case 2:
                lcd.Write("Pressure:");
                lcd.RowSelect(1);
                lcd.Write(pressString);
                i =0;                
            break;
            
            default:            
                i = 0;                
            break;
        }
        
        Red_int = !Red_int;        

        Thread::wait (5000);
    }
}
/*--------------------------------------------------------------------*/

/*------------------------------SERIAL_CMD----------------------------*/
//Interrupt when recieving from serial port
void Rx_interrupt() {
    
    //Wait for serial input
    while (pc.readable()) {
    
        //Return input to serial
        rx_buffer[rx_in] = pc.getc();
        pc.putc(rx_buffer[rx_in]);
    
        //If enter key is pressed, set serial thread signal
        if(rx_buffer[rx_in] == 0xD){
            _serialCMD.signal_set(ENTER_KEY);
        }
    
        //Increment buffer head
        else{
            rx_in = (rx_in + 1);
        }
    }
}

//Check what command what recieved and execute
void serialCMD(){
    
    while(1){
        //Wait for thread signal
        Thread::signal_wait(ENTER_KEY);
        
        //Detach serial interrupt
        pc.attach(NULL, Serial::RxIrq);

        struct tm * s_time;
        char tm_n[4];
        
/*----CARRAGE RETURN-------------*/        
        if(rx_buffer[0] == 0xD){
            pc.puts("\n\r");
            }
/*----READ ALL----------------------------------*/
        else if(strstr(rx_buffer, "READ ALL")){
            pc.puts(" READ ALL\n\r");
        
            //Lock data buffer
            DataBuffer.lock();
        
            //Print all samples to serial
            for(int n=data_t; n<=MAX_SAMPLES; n++){
                pc.puts(data_buffer[n]);
            }
            if(data_t>data_h){
                for(int n=0; n<=(data_t-1); n++){
                    pc.puts(data_buffer[n]);
                }
            }
            
            //Lock data buffer
            DataBuffer.unlock();
        }
/*----DELETE ALL----------------------------------*/
        else if(strstr(rx_buffer, "DELETE ALL")){
            pc.puts(" DELETE ALL\n\r");
            
        //Lock data buffer
            DataBuffer.lock();
            
        //Delete all sampled data
            for(int n=0; n<=MAX_SAMPLES; n++){
                memset(data_buffer[n], NULL, 64);
            }
            data_h = data_t;
            sample_h = sample_t;
            
        //Unlock data buffer
            DataBuffer.unlock();
        }
/*----READ----------------------------------*/
        else if(strstr(rx_buffer, "READ")){
            pc.puts(" READ     \n\r");
            int N = atoi(strncpy(tm_n,&rx_buffer[5],4));
            int S = 0;
            pc.printf("N = %d\n\r",N);
            
        //Lock data buffer
            DataBuffer.lock();
        
        //Check if N is greater than buffer size
            if(N >= MAX_SAMPLES){
                N = MAX_SAMPLES;
            }
            
        //Read N samples from FIFO buffer
            if(N <= 0){
                pc.puts("####ERROR####\n\r");
            }
            else{
                for(int n=data_t; n<=MAX_SAMPLES-1; n++){
                    if(S>=N){}
                    else{
                        pc.puts(data_buffer[n]);
                        S++;
                    }
                }
                for(int n=0; n<=data_t; n++){
                    if(S>=N){}
                    else{
                        pc.puts(data_buffer[n]);
                        S++;
                    }
                }
            }

        //Unlock data buffer
            DataBuffer.unlock();
        }
/*----DELETE----------------------------------*/
        else if(strstr(rx_buffer, "DELETE")){
            pc.puts(" DELETE     \n\r");
        }
/*----SETDATE----------------------------------*/
        else if(strstr(rx_buffer, "SETDATE")){
            time(&raw_time);
            s_time = localtime(&raw_time);
            
        //Update day in time structure            
            int dd = atoi(strncpy(tm_n,&rx_buffer[8],2));
            s_time->tm_mday = dd;
            memset(tm_n, NULL, 4);
            
        //Update month in time structure
            int mm = atoi(strncpy(tm_n,&rx_buffer[11],2));
            s_time->tm_mon = mm-1;
            memset(tm_n, NULL, 4);
            
        //Update year in time structure
            int yyyy = atoi(strncpy(tm_n,&rx_buffer[14],4));
            s_time->tm_year = yyyy-1900;
            memset(tm_n, NULL, 4);
            
        //Set date from updated time structure
            set_time(mktime(s_time));
            strftime(serial_buffer, 80, "\n\r Set Date: %d/%m/%Y\n\r", s_time);
            pc.puts(serial_buffer);
        }
/*----SETTIME---------------------------------*/
        else if(strstr(rx_buffer, "SETTIME")){
            time(&raw_time);
            s_time = localtime(&raw_time);
            
        //Update seconds in time structure
            int ss = atoi(strncpy(tm_n,&rx_buffer[14],2));
            s_time->tm_sec = ss;
            memset(tm_n, NULL, 4);
        
        //Update minutes in time structure
            int mm = atoi(strncpy(tm_n,&rx_buffer[11],2));
            s_time->tm_min = mm;
            memset(tm_n, NULL, 4);
            
        //Update hour in time structure
            int hh = atoi(strncpy(tm_n,&rx_buffer[8],2));
            s_time->tm_hour = hh;
            memset(tm_n, NULL, 4);
        
        //Set time from updated time structure
            set_time(mktime(s_time));
            strftime(serial_buffer, 80, "\n\r Set Time: %X\n\r", s_time);
            pc.puts(serial_buffer);
        }
/*----SETT----------------------------------*/
        else if(strstr(rx_buffer, "SETT")){
            pc.puts(" SETT\n\r");
        }
/*----STATE----------------------------------*/
        else if(strstr(rx_buffer, "STATE")){
            pc.puts(" STATE\n\r");
        }
/*----LOGGING----------------------------------*/
        else if(strstr(rx_buffer, "LOGGING")){
            pc.puts(" LOGGING\n\r");
        }
/*----ERROR---*/
        else{
            pc.puts("####ERROR####\n\r");    
        }
/*----------------------------------------------*/
    
    //Clear serial buffers
        memset(serial_buffer, NULL, 80);
        memset(rx_buffer, NULL, 32);
        rx_in = 0;
    
    //Attach serial interrupt
        pc.attach(&Rx_interrupt, Serial::RxIrq);
    }
}
/*------------------------------------------------*/

void POST () {
    
    pc.printf(" ALL Leds should be flashing\n\r");
    
    for(unsigned int n = 0; n<10; n++) {
        Green_int = ON;
        Blue_int = ON;
        Red_int = ON;
        Green_ext = ON;
        Yellow_ext = ON;
        Red_ext = ON;
    
        wait (0.2);
        Green_int = OFF;
        Blue_int = OFF;
        Red_int = OFF;
        Green_ext = OFF;
        Yellow_ext = OFF;
        Red_ext = OFF;
        wait (0.2);
    }
    
    pc.printf("Switch states:\n\r");
    pc.printf("\tSW_L: %d\n\r\tSW_R %d\n\r", SW_L.read(), SW_R.read());
    pc.printf("\tSW_B: %d\n\r", SW_B.read());
    
    float Temp = Sensor.getTemperature();
    float Pres = Sensor.getPressure();
    float ldrs = LDR_In.read();
    
    pc.printf("Sensor test:\n\r");
    pc.printf("T: %f\tP: %f\tL: %f\n\r",Temp,Pres,ldrs);
    
    pc.printf("LCD Test\n\r");
    
    lcd.Clear();
    lcd.RowSelect(1);
    lcd.Write("*******LCD******");
    lcd.RowSelect(2);
    lcd.Write("******TEST******");
    wait(1);
    lcd.Clear();    
}
    
    