#include "LCD.h"
#include "BMP280.h"

#define ENTER_KEY 1
#define MAX_SAMPLES 120
#define SENSOR_UPDATE 1
#define DATA_READY 1
#define SAMPLING_PERIOD 10 
#define ON 1
#define OFF 0

extern LCD lcd;
extern BMP280 sensor;

/* External LEDs as Open Drain */
extern DigitalOut Red_ext      (PE_15); 
extern DigitalOut Yellow_ext   (PB_10);
extern DigitalOut Green_ext    (PB_11);

/* Configure On-board LEDS */
extern DigitalOut Green_int (LED1);
extern DigitalOut Blue_int (LED2);
extern DigitalOut Red_int (LED3);

/* Configure Digital In Switches */
extern DigitalIn SW_L (PE_12);
extern DigitalIn SW_R (PE_14);
extern DigitalIn SW_B (USER_BUTTON);
/* Configure Analogue Pins  */
/* Analogue IN */
extern AnalogIn LDR_In (PA_0);

/* Congfigure Serial interface */
Serial pc(USBTX, USBRX);

/* Mail */
typedef struct {
    float LDR_Value;
    float temp_Value;
    float press_Value;
} mail_t;

Mail<mail_t, 16> mail_box;

//data FIFO buffer
char data_buffer[MAX_SAMPLES][64];
int sample_h = 0;
int sample_t = 0;
int data_h = 0;
int data_t = 0;
struct tm * sample_epoch;


//Serial_CMD
volatile int rx_in=0;
char rx_buffer[32];
time_t raw_time = time(NULL);
char serial_buffer[80];

extern void POST();
