#include "mbed.h"
#include "TextLCD.h"
#include "Motor.h"

Motor m1(D10, D8, D9);
TextLCD lcd(D12, D11, D5, D4, D3, D2);
InterruptIn button(PC_13);

I2C i2c(D14, D15);
const int addr = 0x90; 
volatile float tmin;
volatile float tmax;

void ISR1()
{
    lcd.cls();
    lcd.printf("Min: %.1f C", tmin/256);
    wait(2);
    lcd.cls();
    lcd.printf("Max: %.1f C", tmax/256);
    wait(2);
    lcd.cls();
}
int main()
{
    button.rise(&ISR1);
    char cmd[2];
    printf("\r\nTCN75 I2C thermometer\r\n");
    cmd[0] = 0x01;
    cmd[1] = 0x00;
    i2c.write(addr, cmd, 2);
    tmin=100*256;
    tmax=-273.15*100;
    while(1) {
        wait(2);
        cmd[0] = 0x00;
        i2c.write(addr, cmd, 1);
        i2c.read(addr, cmd, 2);
        float temp = cmd[0]<<8|cmd[1];
        lcd.printf("Temperatura :\n %.1f C\n", temp/256);
        //printf("Temperatue = %.4f C\r\n", temp/256);
        if(temp<tmin) {
            tmin=temp;
        }
        else if(temp>tmax) {
            tmax=temp;
        }
        if(temp/256>30){
            m1.speed(0.7);
            }
    }
}