#include "mbed.h"
#include "TextLCD.h"

void SetDateTime(int year,int mon, int day, int hour,int min,int sec);

TextLCD lcd(D12, D11, D5, D4, D3, D2, TextLCD::LCD16x2); // rs, e, d4-d7
DigitalOut myled(LED1);
char buf[16];

int main()
{
    lcd.printf("RTC example.");
//set_time(1387188323);
    SetDateTime(2016,10,24,14,17,0);
    lcd.locate(0,1);
    lcd.printf("Time is set.");
    wait(2);
    lcd.locate(0,1);
    lcd.printf(" ");
    while(1) {
        lcd.locate(0,1);
        time_t seconds = time(NULL);
//lcd.printf("Time: ", ctime(&seconds));
        strftime(buf,16, "%H:%M:%S", localtime(&seconds));
        lcd.printf(buf);
        myled = !myled;
        wait(1);

    }
}

void SetDateTime(int year=2013,int mon=0, int day=1, int hour=0,int min=0,int sec=0)
{
    struct tm Clock;
    Clock.tm_year = year - 1900;
    Clock.tm_mon = mon;
    Clock.tm_mday = day;
    Clock.tm_hour = hour;
    Clock.tm_min = min;
    Clock.tm_sec = sec;
    time_t epoch = mktime(&Clock);
    if (epoch == (time_t) -1) {
        error("Error in clock setting\n");
        // Stop here
    }
    set_time(epoch);
}