#include "mbed.h"
#include "buttonArray.h"

// type mode

// buttonArray constructor
buttonArray::buttonArray(button b1, button b2, button b3, button b4, button b5, button b6)
    : button1(b1), button2(b2), button3(b3), button4(b4), button5(b5), button6(b6) {}

//Serial pc(USBTX, USBRX);

// FUNCTIONS

// map input braille to ascii
// braille respresentation here - https://en.wikipedia.org/wiki/Braille_ASCII
char buttonArray::checkVal(char* braille)
{
    //pc.printf(" checkVal \n");
    //char* braille;
    char val = 'K';
    /*int test = button1.getPress();
    sprintf(braille, "%d%d%d%d%d%d", test, button2.getPress(),
            button3.getPress(), button4.getPress(), button5.getPress(), button6.getPress());*/
    //pc.printf(" %s \n", braille);
    if (strcmp(braille, "000000") == 0) val = 'X';
    if (strcmp(braille, "011111") == 0) val = 'A';
    if (strcmp(braille, "001111") == 0) val = 'B';
    if (strcmp(braille, "011011") == 0) val = 'C';
    if (strcmp(braille, "011001") == 0) val = 'D';
    if (strcmp(braille, "011101") == 0) val = 'E';
    if (strcmp(braille, "001011") == 0) val = 'F';
    if (strcmp(braille, "001001") == 0) val = 'G';
    if (strcmp(braille, "001101") == 0) val = 'H';
    if (strcmp(braille, "101101") == 0) val = 'I';
    if (strcmp(braille, "101001") == 0) val = 'J';
    if (strcmp(braille, "010011") == 0) val = 'M';
    if (strcmp(braille, "010101") == 0) val = 'O';
    /*if (strcmp(braille, "011111") == 0) val = 'K';
    if (strcmp(braille, "011111") == 0) val = 'L';
    if (strcmp(braille, "011111") == 0) val = 'N';
    if (strcmp(braille, "011111") == 0) val = 'P';
    if (strcmp(braille, "011111") == 0) val = 'Q';
    if (strcmp(braille, "011111") == 0) val = 'R';
    if (strcmp(braille, "011111") == 0) val = 'S';
    if (strcmp(braille, "011111") == 0) val = 'T';
    if (strcmp(braille, "011111") == 0) val = 'U';
    if (strcmp(braille, "011111") == 0) val = 'V';
    if (strcmp(braille, "011111") == 0) val = 'W';
    if (strcmp(braille, "011111") == 0) val = 'X';
    if (strcmp(braille, "011111") == 0) val = 'Y';
    if (strcmp(braille, "011111") == 0) val = 'Z';*/
    // check if reset
    if (strcmp(braille, "111111") == 0) val = 'Z';
    //pc.printf(" %c \n", val);
    return val;
}

// get braille represention of char
char* buttonArray::getBraille(char val)
{
    char* braille;
    if (val == 'A') braille = "011111";
    if (val == 'X') braille = "000000";
    if (val == 'Z') braille = "111111";
    if (val == 'M') braille = "010011";
    if (val == 'O') braille = "010101";
    if (val == 'K') braille = "100000";
    // check if reset
    if (val == ' ') braille = "111111";
    return braille;
}

// return an array of which pins need to be up
int* buttonArray::pinsUp(char val)
{
    int* pinsup;
    //pinsup = new int[7];
    char* braille = getBraille(val);
    int j = 1;
    for (int i = 0; i < 6; i++) {
        if (braille[i] == '0') {
            pinsup[j] = i+1;
            j++;
        }
    }
    // record size of array in the first element
    pinsup[0] = j;
    return pinsup;
}

// return feedback on which pins need to be corrected
// takes in current and actual char as input and returns status of each char
int* buttonArray::wrongPins(char* inarr, char actual)
{
    // TODO check initial value of wrong
    int* wrong;
    wrong = new int[7];
    char* actarr = getBraille(actual);
    //pc.printf("wrong pins");
    int j = 1;
    for (int i = 0; i < 6; i++) {
        if(inarr[i] != actarr[i]) {
            wrong[j] = i+1;
            //pc.printf("%d ", wrong[j]);
            j++;
        }
    }
    // record size of array in the first element
    wrong[0] = j;
    return wrong;
}

// release buttons
void buttonArray::releaseButtons()
{
    if (button1.getPress()) {
        button1.moveServoOut();
        button1.setState(3);
        button1.setPress(0);
    }
    if (button2.getPress()) {
        button2.moveServoOut();
        button2.setState(3);
        button2.setPress(0);
    }
    if (button3.getPress()) {
        button3.moveServoOut();
        button3.setState(3);
        button3.setPress(0);
    }
    if (button4.getPress()) {
        button4.moveServoOut();
        button4.setState(3);
        button4.setPress(0);
    }
    if (button5.getPress()) {
        button5.moveServoOut();
        button5.setState(3);
        button5.setPress(0);
    }
    if (button6.getPress()) {
        button6.moveServoOut();
        button6.setState(3);
        button6.setPress(0);
    }
}

void buttonArray::setup()
{
    // servos begin at 30 degrees
    // replace with a button setup function
    button1.setup();
    button2.setup();
    button3.setup();
    button4.setup();
    button5.setup();
    button6.setup();
}