#include "mbed.h"
#include "button.h"
#include "emic2.h"

//emic2 myTTS(p28, p27); //serial RX,TX pins to emic
DigitalOut led4(LED4);
DigitalOut led3(LED3);
DigitalOut led2(LED2);

// button constructor
button::button(PwmOut servo, DigitalIn pb, int id)
    : servo(servo), pb(pb), state(0), press(0), id(id) {}
/*button::button(PwmOut servo, DigitalIn pb, AnalogIn lp)
    : servo(servo), pb(pb), linpot(lp), press(0), state(0) {}
*/
//Serial pc(USBTX, USBRX);

// FUNCTIONS

// get servo pin
PwmOut button::getServoPin()
{
    return servo;
}

// get servo pin
void button::setState(int mystate)
{
    state = mystate;
}

void button::setPress(int mypress)
{
    press = mypress;
}

// get servo pin
/*void button::setMode(int mymode)
{
    mode = mymode;
}*/

// get current state of the button
int button::getState()
{
    return state;
}

int button::getID()
{
    return id;
}


int button::getPress()
{
    //pc.printf("%d", press);
    return press;
}

// get current state of the button
int button::getLp()
{
    /*    if (linpot < 2)
            return 1;
        else*/
    return 0;
}

// move servo into the slot
void button::moveServoIn()
{
    //myled = 1;
    // rotate 90 degrees one way
    for(int i=4; i<=7; i++) {
        servo = i/100.0;
        wait(0.01);
    }
    //press = 1;
    switch (id) {
        case 1:
            led2 = 0;
            led3 = 0;
            led4 = 1;
            break;
        case 2:
            led2 = 0;
            led3 = 1;
            led4 = 0;
            break;
        case 3:
            led2 = 0;
            led3 = 1;
            led4 = 1;
            break;
        case 4:
            led2 = 1;
            led3 = 0;
            led4 = 0;
            break;
        case 5:
            led2 = 1;
            led3 = 0;
            led4 = 1;
            break;
        case 6:
            led2 = 1;
            led3 = 1;
            led4 = 0;
            break;
    }
}

// move servo out of the slot
void button::moveServoOut()
{
    //myled = 0;
    for(int i=7; i>4; i--) {
        servo = i/100.0;
        wait(0.01);
    }
    led2 = 0;
    led3 = 0;
    led4 = 0;
}

int button::updateState()
{
    //myled = 0;
    // state 0 - button is up, pb = 0
    if (pb == 0 && state == 3) {
        // nothing happens here, servo is still
        state = 0;
    }
    // state 1 - button is moving down, pb = 1
    if (pb == 1 && state == 0) {
        moveServoIn();
        state = 1;
        press = 1;

        // Speaker says stuff
        /*myTTS.volume(18); //max volume
        myTTS.speakf("S");//Speak command starts with "S"
        myTTS.speakf("Hey, you pressed a pin!");  // Send the desired string to convert to speech
        myTTS.speakf("\r"); //marks end of speak command*/
    }
    // state 2 - button is down, pb = 0
    if (pb == 0 && state == 1) {
        // nothing happens here, servo is still
        state = 2;
    }
    // state 3 - button is moving up, pb = 1
    if (pb == 1 && state == 2) {
        moveServoOut();
        state = 3;
        press = 0;
    }
    // state 4 - handle debouncing while button is down
    /*if (pb1 = 1 && state == 2) {
        count++;
    }*/
    return state;
}

void button::setup() {
    for(int i=0; i<=4; i++) {
        servo = i/100.0;
        wait(0.01);
    }
}
